
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for 3DS Transaction Type contextual list. Examples: Authorize: Authorize amount (no funds transferred) Complete: Complete a previous authorization (funds are transferred) Purchase: Purchase (funds are transferred immediately) Refund: Refund (funds transferred immediately) Validate: Validation Transaction (a small authorized transaction amount to validate card details including expiry date and address)

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecureTransactionListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Authorize"/>
 *     &lt;xs:enumeration value="CheckEnrollment"/>
 *     &lt;xs:enumeration value="Complete"/>
 *     &lt;xs:enumeration value="Purchase"/>
 *     &lt;xs:enumeration value="Refund"/>
 *     &lt;xs:enumeration value="Validate"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SecureTransactionListType implements Serializable {
    /** 
     * Amount is authorized. No funds are transferred.
     */
    AUTHORIZE("Authorize"), CHECK_ENROLLMENT("CheckEnrollment"), /** 
                                                                  * 
                                                                 Complete a previous authorization. Funds are transferred.
                                                                 
                                                                  */
    COMPLETE("Complete"), /** 
                           * Purchase. Funds are transferred immediately.
                           */
    PURCHASE("Purchase"), /** 
                           * Refund. Funds transferred immediately.
                           */
    REFUND("Refund"), /** 
                       * 
                      Validation Transaction. Effects a $1.00 Authorization to validate card details including expiry date, address.
                      
                       */
    VALIDATE("Validate");
    private final String value;

    private SecureTransactionListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SecureTransactionListType convert(String value) {
        for (SecureTransactionListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
