
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Association to one Flight Segment instance. Example: segment1

 Note: Flight Slice On and Off Board Points may also be specified.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SegmentReference">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attribute type="xs:string" use="optional" name="ON_Point"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="OFF_Point"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SegmentReference implements Serializable
{
    private String string;
    private String ONPoint;
    private String OFFPoint;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'ON_Point' attribute value. Flight Slice ON Point.  Example: ORD

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public String getONPoint() {
        return ONPoint;
    }

    /** 
     * Set the 'ON_Point' attribute value. Flight Slice ON Point.  Example: ORD

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param ONPoint
     */
    public void setONPoint(String ONPoint) {
        this.ONPoint = ONPoint;
    }

    /** 
     * Get the 'OFF_Point' attribute value. Flight Slice OFF Point.  Example: NYC

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public String getOFFPoint() {
        return OFFPoint;
    }

    /** 
     * Set the 'OFF_Point' attribute value. Flight Slice OFF Point.  Example: NYC

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param OFFPoint
     */
    public void setOFFPoint(String OFFPoint) {
        this.OFFPoint = OFFPoint;
    }
}
