
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Service Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceAssocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Traveler" minOccurs="0">
 *       &lt;!-- Reference to inner class Traveler -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Flight" minOccurs="0">
 *       &lt;!-- Reference to inner class Flight -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Offer" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:OfferReferences"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:ServiceOtherAssocType" name="OtherAssociations" minOccurs="0"/>
 *     &lt;xs:element ref="ns:SeatReference" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceAssocType implements Serializable
{
    private Traveler traveler;
    private Flight flight;
    private OfferReferences offer;
    private ServiceOtherAssocType otherAssociations;
    private SeatReference seatReference;

    /** 
     * Get the 'Traveler' element value.
     * 
     * @return value
     */
    public Traveler getTraveler() {
        return traveler;
    }

    /** 
     * Set the 'Traveler' element value.
     * 
     * @param traveler
     */
    public void setTraveler(Traveler traveler) {
        this.traveler = traveler;
    }

    /** 
     * Get the 'Flight' element value.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'OfferReferences' element value. Offer Item Association.
     * 
     * @return value
     */
    public OfferReferences getOffer() {
        return offer;
    }

    /** 
     * Set the 'OfferReferences' element value. Offer Item Association.
     * 
     * @param offer
     */
    public void setOffer(OfferReferences offer) {
        this.offer = offer;
    }

    /** 
     * Get the 'OtherAssociations' element value. Other association(s).
     * 
     * @return value
     */
    public ServiceOtherAssocType getOtherAssociations() {
        return otherAssociations;
    }

    /** 
     * Set the 'OtherAssociations' element value. Other association(s).
     * 
     * @param otherAssociations
     */
    public void setOtherAssociations(ServiceOtherAssocType otherAssociations) {
        this.otherAssociations = otherAssociations;
    }

    /** 
     * Get the 'SeatReference' element value.
     * 
     * @return value
     */
    public SeatReference getSeatReference() {
        return seatReference;
    }

    /** 
     * Set the 'SeatReference' element value.
     * 
     * @param seatReference
     */
    public void setSeatReference(SeatReference seatReference) {
        this.seatReference = seatReference;
    }
    /** 
     * Anonymous, Recognized and/or PTC that the offer applies to.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Traveler" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="xs:boolean" name="AllTravelerInd"/>
     *       &lt;xs:element ref="ns:TravelerReferences"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Traveler implements Serializable
    {
        private int travelerSelect = -1;
        private static final int ALL_TRAVELER_IND_CHOICE = 0;
        private static final int TRAVELER_REFERENCES_CHOICE = 1;
        private boolean allTravelerInd;
        private TravelerReferences travelerReferences;

        private void setTravelerSelect(int choice) {
            if (travelerSelect == -1) {
                travelerSelect = choice;
            } else if (travelerSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearTravelerSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearTravelerSelect() {
            travelerSelect = -1;
        }

        /** 
         * Check if AllTravelerInd is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllTravelerInd() {
            return travelerSelect == ALL_TRAVELER_IND_CHOICE;
        }

        /** 
         * Get the 'AllTravelerInd' element value. When TRUE, this Baggage Offer applies to all specified Travelers.
         * 
         * @return value
         */
        public boolean isAllTravelerInd() {
            return allTravelerInd;
        }

        /** 
         * Set the 'AllTravelerInd' element value. When TRUE, this Baggage Offer applies to all specified Travelers.
         * 
         * @param allTravelerInd
         */
        public void setAllTravelerInd(boolean allTravelerInd) {
            setTravelerSelect(ALL_TRAVELER_IND_CHOICE);
            this.allTravelerInd = allTravelerInd;
        }

        /** 
         * Check if TravelerReferences is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelerReferences() {
            return travelerSelect == TRAVELER_REFERENCES_CHOICE;
        }

        /** 
         * Get the 'TravelerReferences' element value. Association to multiple Traveler instance(s). Example: Traveler1 Traveler2

        Note: May be Recognized or Anonymous Traveler (by PTC) instance(s).
         * 
         * @return value
         */
        public TravelerReferences getTravelerReferences() {
            return travelerReferences;
        }

        /** 
         * Set the 'TravelerReferences' element value. Association to multiple Traveler instance(s). Example: Traveler1 Traveler2

        Note: May be Recognized or Anonymous Traveler (by PTC) instance(s).
         * 
         * @param travelerReferences
         */
        public void setTravelerReferences(TravelerReferences travelerReferences) {
            setTravelerSelect(TRAVELER_REFERENCES_CHOICE);
            this.travelerReferences = travelerReferences;
        }
    }
    /** 
     * Flight that the offer applies to.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="xs:boolean" name="AllFlightInd"/>
     *       &lt;xs:element type="xs:boolean" name="AllOriginDestinationInd"/>
     *       &lt;xs:element type="xs:boolean" name="AllSegmentInd"/>
     *       &lt;xs:choice maxOccurs="2">
     *         &lt;!-- Reference to inner class Choice -->
     *       &lt;/xs:choice>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private int flightSelect = -1;
        private static final int ALL_FLIGHT_IND_CHOICE = 0;
        private static final int ALL_ORIGIN_DESTINATION_IND_CHOICE = 1;
        private static final int ALL_SEGMENT_IND_CHOICE = 2;
        private static final int CHOICE_LIST_CHOICE = 3;
        private boolean allFlightInd;
        private boolean allOriginDestinationInd;
        private boolean allSegmentInd;
        private List<Choice> choiceList = new ArrayList<Choice>();

        private void setFlightSelect(int choice) {
            if (flightSelect == -1) {
                flightSelect = choice;
            } else if (flightSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearFlightSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearFlightSelect() {
            flightSelect = -1;
        }

        /** 
         * Check if AllFlightInd is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllFlightInd() {
            return flightSelect == ALL_FLIGHT_IND_CHOICE;
        }

        /** 
         * Get the 'AllFlightInd' element value. When TRUE, this Baggage Offer applies to all specified flights.
         * 
         * @return value
         */
        public boolean isAllFlightInd() {
            return allFlightInd;
        }

        /** 
         * Set the 'AllFlightInd' element value. When TRUE, this Baggage Offer applies to all specified flights.
         * 
         * @param allFlightInd
         */
        public void setAllFlightInd(boolean allFlightInd) {
            setFlightSelect(ALL_FLIGHT_IND_CHOICE);
            this.allFlightInd = allFlightInd;
        }

        /** 
         * Check if AllOriginDestinationInd is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllOriginDestinationInd() {
            return flightSelect == ALL_ORIGIN_DESTINATION_IND_CHOICE;
        }

        /** 
         * Get the 'AllOriginDestinationInd' element value. When TRUE, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
         * 
         * @return value
         */
        public boolean isAllOriginDestinationInd() {
            return allOriginDestinationInd;
        }

        /** 
         * Set the 'AllOriginDestinationInd' element value. When TRUE, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
         * 
         * @param allOriginDestinationInd
         */
        public void setAllOriginDestinationInd(boolean allOriginDestinationInd) {
            setFlightSelect(ALL_ORIGIN_DESTINATION_IND_CHOICE);
            this.allOriginDestinationInd = allOriginDestinationInd;
        }

        /** 
         * Check if AllSegmentInd is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllSegmentInd() {
            return flightSelect == ALL_SEGMENT_IND_CHOICE;
        }

        /** 
         * Get the 'AllSegmentInd' element value. When TRUE, this Baggage Offer applies to all specified flight Segments.
         * 
         * @return value
         */
        public boolean isAllSegmentInd() {
            return allSegmentInd;
        }

        /** 
         * Set the 'AllSegmentInd' element value. When TRUE, this Baggage Offer applies to all specified flight Segments.
         * 
         * @param allSegmentInd
         */
        public void setAllSegmentInd(boolean allSegmentInd) {
            setFlightSelect(ALL_SEGMENT_IND_CHOICE);
            this.allSegmentInd = allSegmentInd;
        }

        /** 
         * Check if ChoiceList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifChoiceList() {
            return flightSelect == CHOICE_LIST_CHOICE;
        }

        /** 
         * Get the list of choice items.
         * 
         * @return list
         */
        public List<Choice> getChoiceList() {
            return choiceList;
        }

        /** 
         * Set the list of choice items.
         * 
         * @param list
         */
        public void setChoiceList(List<Choice> list) {
            setFlightSelect(CHOICE_LIST_CHOICE);
            choiceList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
         *   &lt;xs:element ref="ns:OriginDestinationReferences"/>
         *   &lt;xs:element ref="ns:SegmentReferences"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceListSelect = -1;
            private static final int ORIGIN_DESTINATION_REFERENCES_CHOICE = 0;
            private static final int SEGMENT_REFERENCES_CHOICE = 1;
            private OriginDestinationReferences originDestinationReferences;
            private SegmentReferences segmentReferences;

            private void setChoiceListSelect(int choice) {
                if (choiceListSelect == -1) {
                    choiceListSelect = choice;
                } else if (choiceListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceListSelect() {
                choiceListSelect = -1;
            }

            /** 
             * Check if OriginDestinationReferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifOriginDestinationReferences() {
                return choiceListSelect == ORIGIN_DESTINATION_REFERENCES_CHOICE;
            }

            /** 
             * Get the 'OriginDestinationReferences' element value.
             * 
             * @return value
             */
            public OriginDestinationReferences getOriginDestinationReferences() {
                return originDestinationReferences;
            }

            /** 
             * Set the 'OriginDestinationReferences' element value.
             * 
             * @param originDestinationReferences
             */
            public void setOriginDestinationReferences(
                    OriginDestinationReferences originDestinationReferences) {
                setChoiceListSelect(ORIGIN_DESTINATION_REFERENCES_CHOICE);
                this.originDestinationReferences = originDestinationReferences;
            }

            /** 
             * Check if SegmentReferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSegmentReferences() {
                return choiceListSelect == SEGMENT_REFERENCES_CHOICE;
            }

            /** 
             * Get the 'SegmentReferences' element value.
             * 
             * @return value
             */
            public SegmentReferences getSegmentReferences() {
                return segmentReferences;
            }

            /** 
             * Set the 'SegmentReferences' element value.
             * 
             * @param segmentReferences
             */
            public void setSegmentReferences(SegmentReferences segmentReferences) {
                setChoiceListSelect(SEGMENT_REFERENCES_CHOICE);
                this.segmentReferences = segmentReferences;
            }
        }
    }
}
