
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 Optional Service Filter Notification. Note: Supports ATPCO group and subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceFilterNoticeType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TrxProcessObjectBaseType">
 *       &lt;xs:choice>
 *         &lt;xs:element name="Query">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element type="ns:ServiceFilterType" name="ServiceFilter" maxOccurs="unbounded"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Results">
 *           &lt;!-- Reference to inner class Results -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceFilterNoticeType extends TrxProcessObjectBaseType implements
    Serializable
{
    private int choiceSelect = -1;
    private static final int QUERY_CHOICE = 0;
    private static final int RESULTS_CHOICE = 1;
    private List<ServiceFilterType> queryList = new ArrayList<ServiceFilterType>();
    private Results results;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if QueryList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    /** 
     * Get the list of 'ServiceFilter' element items. Alternate Offer Rules.
     * 
     * @return list
     */
    public List<ServiceFilterType> getQueryList() {
        return queryList;
    }

    /** 
     * Set the list of 'ServiceFilter' element items. Alternate Offer Rules.
     * 
     * @param list
     */
    public void setQueryList(List<ServiceFilterType> list) {
        setChoiceSelect(QUERY_CHOICE);
        queryList = list;
    }

    /** 
     * Check if Results is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResults() {
        return choiceSelect == RESULTS_CHOICE;
    }

    /** 
     * Get the 'Results' element value.
     * 
     * @return value
     */
    public Results getResults() {
        return results;
    }

    /** 
     * Set the 'Results' element value.
     * 
     * @param results
     */
    public void setResults(Results results) {
        setChoiceSelect(RESULTS_CHOICE);
        this.results = results;
    }
    /** 
     * 
                  Alternate Offers created during transaction processing.
                
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Results">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AppliedFilters" minOccurs="0">
     *         &lt;!-- Reference to inner class AppliedFilters -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="SrvcFilterAppliedInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Results implements Serializable
    {
        private AppliedFilters appliedFilters;
        private Boolean srvcFilterAppliedInd;

        /** 
         * Get the 'AppliedFilters' element value.
         * 
         * @return value
         */
        public AppliedFilters getAppliedFilters() {
            return appliedFilters;
        }

        /** 
         * Set the 'AppliedFilters' element value.
         * 
         * @param appliedFilters
         */
        public void setAppliedFilters(AppliedFilters appliedFilters) {
            this.appliedFilters = appliedFilters;
        }

        /** 
         * Get the 'SrvcFilterAppliedInd' attribute value. 
                        When TRUE, service filters specified in the request message have resulted in offers in this reponse.
                      
         * 
         * @return value
         */
        public Boolean getSrvcFilterAppliedInd() {
            return srvcFilterAppliedInd;
        }

        /** 
         * Set the 'SrvcFilterAppliedInd' attribute value. 
                        When TRUE, service filters specified in the request message have resulted in offers in this reponse.
                      
         * 
         * @param srvcFilterAppliedInd
         */
        public void setSrvcFilterAppliedInd(Boolean srvcFilterAppliedInd) {
            this.srvcFilterAppliedInd = srvcFilterAppliedInd;
        }
        /** 
         * 
                          Optional Service Filter(s) applied during transaction processing. Note: This is a list of requested optional service filters that apply to returned offers.
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AppliedFilters" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AppliedFilter" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class AppliedFilter -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AppliedFilters implements Serializable
        {
            private List<AppliedFilter> appliedFilterList = new ArrayList<AppliedFilter>();

            /** 
             * Get the list of 'AppliedFilter' element items.
             * 
             * @return list
             */
            public List<AppliedFilter> getAppliedFilterList() {
                return appliedFilterList;
            }

            /** 
             * Set the list of 'AppliedFilter' element items.
             * 
             * @param list
             */
            public void setAppliedFilterList(List<AppliedFilter> list) {
                appliedFilterList = list;
            }
            /** 
             * Applied Optional Service Filter(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AppliedFilter" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:ServiceFilterType">
             *         &lt;xs:sequence>
             *           &lt;xs:element name="Associations" minOccurs="0">
             *             &lt;!-- Reference to inner class Associations -->
             *           &lt;/xs:element>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AppliedFilter extends ServiceFilterType
                implements Serializable
            {
                private Associations associations;

                /** 
                 * Get the 'Associations' element value.
                 * 
                 * @return value
                 */
                public Associations getAssociations() {
                    return associations;
                }

                /** 
                 * Set the 'Associations' element value.
                 * 
                 * @param associations
                 */
                public void setAssociations(Associations associations) {
                    this.associations = associations;
                }
                /** 
                 * Association(s).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:choice>
                 *       &lt;xs:element name="Offer">
                 *         &lt;!-- Reference to inner class Offer -->
                 *       &lt;/xs:element>
                 *       &lt;xs:element type="ns:OrderItemAssociationType" name="Order"/>
                 *     &lt;/xs:choice>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Associations implements Serializable
                {
                    private int associationsSelect = -1;
                    private static final int OFFER_CHOICE = 0;
                    private static final int ORDER_CHOICE = 1;
                    private Offer offer;
                    private OrderItemAssociationType order;

                    private void setAssociationsSelect(int choice) {
                        if (associationsSelect == -1) {
                            associationsSelect = choice;
                        } else if (associationsSelect != choice) {
                            throw new IllegalStateException(
                                    "Need to call clearAssociationsSelect() before changing existing choice");
                        }
                    }

                    /** 
                     * Clear the choice selection.
                     */
                    public void clearAssociationsSelect() {
                        associationsSelect = -1;
                    }

                    /** 
                     * Check if Offer is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifOffer() {
                        return associationsSelect == OFFER_CHOICE;
                    }

                    /** 
                     * Get the 'Offer' element value.
                     * 
                     * @return value
                     */
                    public Offer getOffer() {
                        return offer;
                    }

                    /** 
                     * Set the 'Offer' element value.
                     * 
                     * @param offer
                     */
                    public void setOffer(Offer offer) {
                        setAssociationsSelect(OFFER_CHOICE);
                        this.offer = offer;
                    }

                    /** 
                     * Check if Order is current selection for choice.
                     * 
                     * @return <code>true</code> if selection, <code>false</code> if not
                     */
                    public boolean ifOrder() {
                        return associationsSelect == ORDER_CHOICE;
                    }

                    /** 
                     * Get the 'Order' element value. Order Association(s).
                     * 
                     * @return value
                     */
                    public OrderItemAssociationType getOrder() {
                        return order;
                    }

                    /** 
                     * Set the 'Order' element value. Order Association(s).
                     * 
                     * @param order
                     */
                    public void setOrder(OrderItemAssociationType order) {
                        setAssociationsSelect(ORDER_CHOICE);
                        this.order = order;
                    }
                    /** 
                     * Shopping Offer Association(s).
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer">
                     *   &lt;xs:complexType>
                     *     &lt;xs:sequence>
                     *       &lt;xs:element type="ns:ShopperInfoAssocType" name="Shopper" minOccurs="0"/>
                     *       &lt;xs:element type="ns:FlightInfoAssocType" name="Flight" minOccurs="0"/>
                     *       &lt;xs:element name="PriceClass" minOccurs="0">
                     *         &lt;xs:complexType>
                     *           &lt;xs:sequence>
                     *             &lt;xs:element ref="ns:PriceClassReference"/>
                     *           &lt;/xs:sequence>
                     *         &lt;/xs:complexType>
                     *       &lt;/xs:element>
                     *       &lt;xs:element type="ns:BagDetailAssocType" name="BagDetails" minOccurs="0"/>
                     *       &lt;xs:element type="ns:OfferDetailInfoAssocType" name="OfferDetails" minOccurs="0"/>
                     *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                     *         &lt;!-- Reference to inner class OtherAssociation -->
                     *       &lt;/xs:element>
                     *     &lt;/xs:sequence>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class Offer implements Serializable
                    {
                        private ShopperInfoAssocType shopper;
                        private FlightInfoAssocType flight;
                        private PriceClassReference priceClass;
                        private BagDetailAssocType bagDetails;
                        private OfferDetailInfoAssocType offerDetails;
                        private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                        /** 
                         * Get the 'Shopper' element value. Associated Shoppers. Note: Includes Anonymous, Recognized and/or PTC shopper association.
                                                            
                         * 
                         * @return value
                         */
                        public ShopperInfoAssocType getShopper() {
                            return shopper;
                        }

                        /** 
                         * Set the 'Shopper' element value. Associated Shoppers. Note: Includes Anonymous, Recognized and/or PTC shopper association.
                                                            
                         * 
                         * @param shopper
                         */
                        public void setShopper(ShopperInfoAssocType shopper) {
                            this.shopper = shopper;
                        }

                        /** 
                         * Get the 'Flight' element value. Associated Flight(s).
                         * 
                         * @return value
                         */
                        public FlightInfoAssocType getFlight() {
                            return flight;
                        }

                        /** 
                         * Set the 'Flight' element value. Associated Flight(s).
                         * 
                         * @param flight
                         */
                        public void setFlight(FlightInfoAssocType flight) {
                            this.flight = flight;
                        }

                        /** 
                         * Get the 'PriceClassReference' element value. Associated Price Class information.
                         * 
                         * @return value
                         */
                        public PriceClassReference getPriceClass() {
                            return priceClass;
                        }

                        /** 
                         * Set the 'PriceClassReference' element value. Associated Price Class information.
                         * 
                         * @param priceClass
                         */
                        public void setPriceClass(PriceClassReference priceClass) {
                            this.priceClass = priceClass;
                        }

                        /** 
                         * Get the 'BagDetails' element value. Baggage Detail Associations.
                         * 
                         * @return value
                         */
                        public BagDetailAssocType getBagDetails() {
                            return bagDetails;
                        }

                        /** 
                         * Set the 'BagDetails' element value. Baggage Detail Associations.
                         * 
                         * @param bagDetails
                         */
                        public void setBagDetails(BagDetailAssocType bagDetails) {
                            this.bagDetails = bagDetails;
                        }

                        /** 
                         * Get the 'OfferDetails' element value. Offer Detail Association(s).
                         * 
                         * @return value
                         */
                        public OfferDetailInfoAssocType getOfferDetails() {
                            return offerDetails;
                        }

                        /** 
                         * Set the 'OfferDetails' element value. Offer Detail Association(s).
                         * 
                         * @param offerDetails
                         */
                        public void setOfferDetails(
                                OfferDetailInfoAssocType offerDetails) {
                            this.offerDetails = offerDetails;
                        }

                        /** 
                         * Get the list of 'OtherAssociation' element items.
                         * 
                         * @return list
                         */
                        public List<OtherAssociation> getOtherAssociationList() {
                            return otherAssociationList;
                        }

                        /** 
                         * Set the list of 'OtherAssociation' element items.
                         * 
                         * @param list
                         */
                        public void setOtherAssociationList(
                                List<OtherAssociation> list) {
                            otherAssociationList = list;
                        }
                        /** 
                         * 
                                                              Other Named Association(s). Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                                                            
                         * 
                         * Schema fragment(s) for this class:
                         * <pre>
                         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                         *   &lt;xs:complexType>
                         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                         *     &lt;xs:attribute type="xs:string" use="required" name="RefValue"/>
                         *   &lt;/xs:complexType>
                         * &lt;/xs:element>
                         * </pre>
                         */
                        public static class OtherAssociation implements
                            Serializable
                        {
                            private String type;
                            private String refValue;

                            /** 
                             * Get the 'Type' attribute value. 
                                                                    Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                                                  
                             * 
                             * @return value
                             */
                            public String getType() {
                                return type;
                            }

                            /** 
                             * Set the 'Type' attribute value. 
                                                                    Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                                                                  
                             * 
                             * @param type
                             */
                            public void setType(String type) {
                                this.type = type;
                            }

                            /** 
                             * Get the 'RefValue' attribute value. 
                                                                    Associated object instance value. Example: mediagrp1
                                                                  
                             * 
                             * @return value
                             */
                            public String getRefValue() {
                                return refValue;
                            }

                            /** 
                             * Set the 'RefValue' attribute value. 
                                                                    Associated object instance value. Example: mediagrp1
                                                                  
                             * 
                             * @param refValue
                             */
                            public void setRefValue(String refValue) {
                                this.refValue = refValue;
                            }
                        }
                    }
                }
            }
        }
    }
}
