
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * MINIMUM/ MAXIMUM Service Ordering Quantity definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceItemQuantityType">
 *   &lt;xs:choice maxOccurs="2">
 *     &lt;!-- Reference to inner class Choice -->
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceItemQuantityType implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();

    /** 
     * Get the list of 'ServiceItemQuantityType' complexType items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of 'ServiceItemQuantityType' complexType items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
     *   &lt;xs:element type="xs:string" name="MinimumQuantity"/>
     *   &lt;xs:element type="xs:string" name="MaximumQuantity"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int MINIMUM_QUANTITY_CHOICE = 0;
        private static final int MAXIMUM_QUANTITY_CHOICE = 1;
        private String minimumQuantity;
        private String maximumQuantity;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if MinimumQuantity is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMinimumQuantity() {
            return choiceListSelect == MINIMUM_QUANTITY_CHOICE;
        }

        /** 
         * Get the 'MinimumQuantity' element value. The MINIMUM Quantity of the Service Item that may be ordered.
        Example: 2
         * 
         * @return value
         */
        public String getMinimumQuantity() {
            return minimumQuantity;
        }

        /** 
         * Set the 'MinimumQuantity' element value. The MINIMUM Quantity of the Service Item that may be ordered.
        Example: 2
         * 
         * @param minimumQuantity
         */
        public void setMinimumQuantity(String minimumQuantity) {
            setChoiceListSelect(MINIMUM_QUANTITY_CHOICE);
            this.minimumQuantity = minimumQuantity;
        }

        /** 
         * Check if MaximumQuantity is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMaximumQuantity() {
            return choiceListSelect == MAXIMUM_QUANTITY_CHOICE;
        }

        /** 
         * Get the 'MaximumQuantity' element value. The MAXIMUM Quantity of the Service Item that may be ordered.
        Example: 4
         * 
         * @return value
         */
        public String getMaximumQuantity() {
            return maximumQuantity;
        }

        /** 
         * Set the 'MaximumQuantity' element value. The MAXIMUM Quantity of the Service Item that may be ordered.
        Example: 4
         * 
         * @param maximumQuantity
         */
        public void setMaximumQuantity(String maximumQuantity) {
            setChoiceListSelect(MAXIMUM_QUANTITY_CHOICE);
            this.maximumQuantity = maximumQuantity;
        }
    }
}
