
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The ServicePrice transaction set allows individual seats and/or known a la carte ancillary services to be priced on demand.

 The response message returns pricing of seat/services meeting the request qualifiers. The message also returns multi-media content at the message level with media references at the individual service level.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServicePriceRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Document"/>
 *         &lt;xs:element type="ns:SuccessType" name="Success"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:element type="ns:ServicePriceProcessType" name="Processing" minOccurs="0"/>
 *         &lt;xs:element ref="ns:ShoppingResponseIDs" minOccurs="0"/>
 *         &lt;xs:element type="ns:SrvPriceResParamsType" name="Parameters" minOccurs="0"/>
 *         &lt;xs:element name="Services" minOccurs="0">
 *           &lt;!-- Reference to inner class Services -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:DataListType" name="DataLists" minOccurs="0"/>
 *         &lt;xs:element type="ns:SrvPriceResMetadataType" name="Metadata" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Errors"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ServicePriceRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int DOCUMENT_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private MsgDocumentType document;
    private SuccessType success;
    private WarningsType warnings;
    private ServicePriceProcessType processing;
    private ShoppingResponseIDType shoppingResponseIDs;
    private SrvPriceResParamsType parameters;
    private Services services;
    private DataListType dataLists;
    private SrvPriceResMetadataType metadata;
    private Policies policies;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'Processing' element value.
     * 
     * @return value
     */
    public ServicePriceProcessType getProcessing() {
        return processing;
    }

    /** 
     * Set the 'Processing' element value.
     * 
     * @param processing
     */
    public void setProcessing(ServicePriceProcessType processing) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.processing = processing;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseIDs() {
        return shoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param shoppingResponseIDs
     */
    public void setShoppingResponseIDs(
            ShoppingResponseIDType shoppingResponseIDs) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.shoppingResponseIDs = shoppingResponseIDs;
    }

    /** 
     * Get the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public SrvPriceResParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(SrvPriceResParamsType parameters) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.parameters = parameters;
    }

    /** 
     * Get the 'Services' element value.
     * 
     * @return value
     */
    public Services getServices() {
        return services;
    }

    /** 
     * Set the 'Services' element value.
     * 
     * @param services
     */
    public void setServices(Services services) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.services = services;
    }

    /** 
     * Get the 'DataLists' element value. Data Lists(s).
     * 
     * @return value
     */
    public DataListType getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data Lists(s).
     * 
     * @param dataLists
     */
    public void setDataLists(DataListType dataLists) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public SrvPriceResMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(SrvPriceResMetadataType metadata) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.policies = policies;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Service(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ServiceDetailType" name="Service" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Services implements Serializable
    {
        private List<ServiceDetailType> serviceList = new ArrayList<ServiceDetailType>();

        /** 
         * Get the list of 'Service' element items. Service detail.
         * 
         * @return list
         */
        public List<ServiceDetailType> getServiceList() {
            return serviceList;
        }

        /** 
         * Set the list of 'Service' element items. Service detail.
         * 
         * @param list
         */
        public void setServiceList(List<ServiceDetailType> list) {
            serviceList = list;
        }
    }
}
