
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Specific structure for providing flight associations, would typically associate to flights from a Data List.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SimpleFlightAssocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:OriginDestinationReference" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FlightReferences" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FlightSegmentReferences" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SimpleFlightAssocType implements Serializable
{
    private OriginDestinationReference originDestinationReference;
    private FlightReferences flightReferences;
    private FlightSegmentReferences flightSegmentReferences;

    /** 
     * Get the 'OriginDestinationReference' element value.
     * 
     * @return value
     */
    public OriginDestinationReference getOriginDestinationReference() {
        return originDestinationReference;
    }

    /** 
     * Set the 'OriginDestinationReference' element value.
     * 
     * @param originDestinationReference
     */
    public void setOriginDestinationReference(
            OriginDestinationReference originDestinationReference) {
        this.originDestinationReference = originDestinationReference;
    }

    /** 
     * Get the 'FlightReferences' element value.
     * 
     * @return value
     */
    public FlightReferences getFlightReferences() {
        return flightReferences;
    }

    /** 
     * Set the 'FlightReferences' element value.
     * 
     * @param flightReferences
     */
    public void setFlightReferences(FlightReferences flightReferences) {
        this.flightReferences = flightReferences;
    }

    /** 
     * Get the 'FlightSegmentReferences' element value.
     * 
     * @return value
     */
    public FlightSegmentReferences getFlightSegmentReferences() {
        return flightSegmentReferences;
    }

    /** 
     * Set the 'FlightSegmentReferences' element value.
     * 
     * @param flightSegmentReferences
     */
    public void setFlightSegmentReferences(
            FlightSegmentReferences flightSegmentReferences) {
        this.flightSegmentReferences = flightSegmentReferences;
    }
}
