
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Social Media Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SocialMediaQualifierType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Service"/>
 *         &lt;xs:element name="User" minOccurs="0">
 *           &lt;!-- Reference to inner class User -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:EmailID_Type" name="EmailAddress" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SocialMediaQualifierType extends KeyWithMetaObjectBaseType
    implements Serializable
{
    private String service;
    private User user;
    private EmailIDType emailAddress;

    /** 
     * Get the 'Service' element value. Social media service/ program name. Examples: FACEBOOK, TWITTER
     * 
     * @return value
     */
    public String getService() {
        return service;
    }

    /** 
     * Set the 'Service' element value. Social media service/ program name. Examples: FACEBOOK, TWITTER
     * 
     * @param service
     */
    public void setService(String service) {
        this.service = service;
    }

    /** 
     * Get the 'User' element value.
     * 
     * @return value
     */
    public User getUser() {
        return user;
    }

    /** 
     * Set the 'User' element value.
     * 
     * @param user
     */
    public void setUser(User user) {
        this.user = user;
    }

    /** 
     * Get the 'EmailAddress' element value. Email address. Example: John.Smith@Here.com
     * 
     * @return value
     */
    public EmailIDType getEmailAddress() {
        return emailAddress;
    }

    /** 
     * Set the 'EmailAddress' element value. Email address. Example: John.Smith@Here.com
     * 
     * @param emailAddress
     */
    public void setEmailAddress(EmailIDType emailAddress) {
        this.emailAddress = emailAddress;
    }
    /** 
     * User or profile identification.
    Example: JOHNSMITH2367
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="User" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class User implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
