
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Service Coupon Type constrained list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SrvceCouponListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="E-Ticket"/>
 *     &lt;xs:enumeration value="Flight"/>
 *     &lt;xs:enumeration value="No_EMD"/>
 *     &lt;xs:enumeration value="Standalone"/>
 *     &lt;xs:enumeration value="Ticket"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SrvceCouponListType implements Serializable {
    E_TICKET("E-Ticket"), FLIGHT("Flight"), NO_EMD("No_EMD"), STANDALONE(
            "Standalone"), TICKET("Ticket"), OTHER("Other");
    private final String value;

    private SrvceCouponListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static SrvceCouponListType convert(String value) {
        for (SrvceCouponListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
