
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * STATE/PROVINCE PROXIMITY representation.

 Note: This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StateProvProximityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:LocationProximityType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="StateCode">
 *           &lt;xs:complexType>
 *             &lt;xs:complexContent>
 *               &lt;xs:extension base="xs:string">
 *                 &lt;xs:attributeGroup ref="ns:RadiusAttrGroup"/>
 *                 &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:complexContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StateProvProximityType extends LocationProximityType implements
    Serializable
{
    private RadiusAttrGroup stateCodeRadiusAttrGroup;
    private PreferenceAttrGroup stateCodePreferenceAttrGroup;

    /** 
     * Get the 'RadiusAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public RadiusAttrGroup getStateCodeRadiusAttrGroup() {
        return stateCodeRadiusAttrGroup;
    }

    /** 
     * Set the 'RadiusAttrGroup' attributeGroup value.
     * 
     * @param stateCodeRadiusAttrGroup
     */
    public void setStateCodeRadiusAttrGroup(
            RadiusAttrGroup stateCodeRadiusAttrGroup) {
        this.stateCodeRadiusAttrGroup = stateCodeRadiusAttrGroup;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getStateCodePreferenceAttrGroup() {
        return stateCodePreferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param stateCodePreferenceAttrGroup
     */
    public void setStateCodePreferenceAttrGroup(
            PreferenceAttrGroup stateCodePreferenceAttrGroup) {
        this.stateCodePreferenceAttrGroup = stateCodePreferenceAttrGroup;
    }
}
