
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for a Message Target System Type constrained list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TargetSystemListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Production"/>
 *     &lt;xs:enumeration value="Staging"/>
 *     &lt;xs:enumeration value="Test"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TargetSystemListType implements Serializable {
    /** 
     * K = KILOMETERS
     */
    PRODUCTION("Production"), /** 
                               * M = MILES
                               */
    STAGING("Staging"), TEST("Test"), OTHER("Other");
    private final String value;

    private TargetSystemListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TargetSystemListType convert(String value) {
        for (TargetSystemListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
