
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Used to specify tax information for a coupon.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCouponInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TicketDocument" maxOccurs="4">
 *       &lt;!-- Reference to inner class TicketDocument -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:date" use="optional" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="JourneyTurnaroundCityCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxCouponInfoType implements Serializable
{
    private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
    private java.sql.Date birthDate;
    private String journeyTurnaroundCityCode;

    /** 
     * Get the list of 'TicketDocument' element items.
     * 
     * @return list
     */
    public List<TicketDocument> getTicketDocumentList() {
        return ticketDocumentList;
    }

    /** 
     * Set the list of 'TicketDocument' element items.
     * 
     * @param list
     */
    public void setTicketDocumentList(List<TicketDocument> list) {
        ticketDocumentList = list;
    }

    /** 
     * Get the 'BirthDate' attribute value. The date of birth of the passenger.
     * 
     * @return value
     */
    public java.sql.Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value. The date of birth of the passenger.
     * 
     * @param birthDate
     */
    public void setBirthDate(java.sql.Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'JourneyTurnaroundCityCode' attribute value. The airport/city code which has been assumed to be the journey turnaround point in the construction of the itinerary by the pricing system.
     * 
     * @return value
     */
    public String getJourneyTurnaroundCityCode() {
        return journeyTurnaroundCityCode;
    }

    /** 
     * Set the 'JourneyTurnaroundCityCode' attribute value. The airport/city code which has been assumed to be the journey turnaround point in the construction of the itinerary by the pricing system.
     * 
     * @param journeyTurnaroundCityCode
     */
    public void setJourneyTurnaroundCityCode(String journeyTurnaroundCityCode) {
        this.journeyTurnaroundCityCode = journeyTurnaroundCityCode;
    }
    /** 
     * The ticket/document number to which the tax coupon data applies.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocument" maxOccurs="4">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="CouponNumber" maxOccurs="4">
     *         &lt;!-- Reference to inner class CouponNumber -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="required" name="TicketDocumentNbr"/>
     *     &lt;xs:attribute type="xs:date" name="DateOfIssue"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocument implements Serializable
    {
        private List<CouponNumber> couponNumberList = new ArrayList<CouponNumber>();
        private String ticketDocumentNbr;
        private java.sql.Date dateOfIssue;

        /** 
         * Get the list of 'CouponNumber' element items.
         * 
         * @return list
         */
        public List<CouponNumber> getCouponNumberList() {
            return couponNumberList;
        }

        /** 
         * Set the list of 'CouponNumber' element items.
         * 
         * @param list
         */
        public void setCouponNumberList(List<CouponNumber> list) {
            couponNumberList = list;
        }

        /** 
         * Get the 'TicketDocumentNbr' attribute value. The ticket/document number for this transaction.
         * 
         * @return value
         */
        public String getTicketDocumentNbr() {
            return ticketDocumentNbr;
        }

        /** 
         * Set the 'TicketDocumentNbr' attribute value. The ticket/document number for this transaction.
         * 
         * @param ticketDocumentNbr
         */
        public void setTicketDocumentNbr(String ticketDocumentNbr) {
            this.ticketDocumentNbr = ticketDocumentNbr;
        }

        /** 
         * Get the 'DateOfIssue' attribute value. The date of issue of the document.
         * 
         * @return value
         */
        public java.sql.Date getDateOfIssue() {
            return dateOfIssue;
        }

        /** 
         * Set the 'DateOfIssue' attribute value. The date of issue of the document.
         * 
         * @param dateOfIssue
         */
        public void setDateOfIssue(java.sql.Date dateOfIssue) {
            this.dateOfIssue = dateOfIssue;
        }
        /** 
         * The applicable coupon number.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponNumber" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="TaxCouponInfo" minOccurs="0">
         *         &lt;!-- Reference to inner class TaxCouponInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
         *         &lt;!-- Reference to inner class Tax -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="UnticketedPointInfo" minOccurs="0" maxOccurs="5">
         *         &lt;!-- Reference to inner class UnticketedPointInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Number"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CouponNumber implements Serializable
        {
            private TaxCouponInfo taxCouponInfo;
            private List<Tax> taxList = new ArrayList<Tax>();
            private List<UnticketedPointInfo> unticketedPointInfoList = new ArrayList<UnticketedPointInfo>();
            private BigInteger number;

            /** 
             * Get the 'TaxCouponInfo' element value.
             * 
             * @return value
             */
            public TaxCouponInfo getTaxCouponInfo() {
                return taxCouponInfo;
            }

            /** 
             * Set the 'TaxCouponInfo' element value.
             * 
             * @param taxCouponInfo
             */
            public void setTaxCouponInfo(TaxCouponInfo taxCouponInfo) {
                this.taxCouponInfo = taxCouponInfo;
            }

            /** 
             * Get the list of 'Tax' element items.
             * 
             * @return list
             */
            public List<Tax> getTaxList() {
                return taxList;
            }

            /** 
             * Set the list of 'Tax' element items.
             * 
             * @param list
             */
            public void setTaxList(List<Tax> list) {
                taxList = list;
            }

            /** 
             * Get the list of 'UnticketedPointInfo' element items.
             * 
             * @return list
             */
            public List<UnticketedPointInfo> getUnticketedPointInfoList() {
                return unticketedPointInfoList;
            }

            /** 
             * Set the list of 'UnticketedPointInfo' element items.
             * 
             * @param list
             */
            public void setUnticketedPointInfoList(
                    List<UnticketedPointInfo> list) {
                unticketedPointInfoList = list;
            }

            /** 
             * Get the 'Number' attribute value. The coupon number.
             * 
             * @return value
             */
            public BigInteger getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value. The coupon number.
             * 
             * @param number
             */
            public void setNumber(BigInteger number) {
                this.number = number;
            }
            /** 
             * The tax information for a coupon.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCouponInfo" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Cabin"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TaxCouponInfo implements Serializable
            {
                private String cabin;
                private String airEquipType;

                /** 
                 * Get the 'Cabin' attribute value. The sold cabin of passenger travel for the coupon.
                 * 
                 * @return value
                 */
                public String getCabin() {
                    return cabin;
                }

                /** 
                 * Set the 'Cabin' attribute value. The sold cabin of passenger travel for the coupon.
                 * 
                 * @param cabin
                 */
                public void setCabin(String cabin) {
                    this.cabin = cabin;
                }

                /** 
                 * Get the 'AirEquipType' attribute value. The standard code of the equipment used for the coupon flight.
                 * 
                 * @return value
                 */
                public String getAirEquipType() {
                    return airEquipType;
                }

                /** 
                 * Set the 'AirEquipType' attribute value. The standard code of the equipment used for the coupon flight.
                 * 
                 * @param airEquipType
                 */
                public void setAirEquipType(String airEquipType) {
                    this.airEquipType = airEquipType;
                }
            }
            /** 
             * The tax/fee charge for this coupon.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:TaxDetailType">
             *         &lt;xs:attribute type="xs:string" name="AirportCode"/>
             *         &lt;xs:attribute type="xs:decimal" name="ApplicableAmount"/>
             *         &lt;xs:attribute type="xs:string" name="CurrencyType"/>
             *         &lt;xs:attribute type="xs:decimal" name="ReportedAmount"/>
             *         &lt;xs:attribute type="xs:string" name="SegmentOriginAirportCode"/>
             *         &lt;xs:attribute type="xs:string" name="SegmentDestAirportCode"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Tax extends TaxDetailType implements
                Serializable
            {
                private String airportCode;
                private BigDecimal applicableAmount;
                private String currencyType;
                private BigDecimal reportedAmount;
                private String segmentOriginAirportCode;
                private String segmentDestAirportCode;

                /** 
                 * Get the 'AirportCode' attribute value. The airport code identifying the airort to which the coupon tax applies.
                 * 
                 * @return value
                 */
                public String getAirportCode() {
                    return airportCode;
                }

                /** 
                 * Set the 'AirportCode' attribute value. The airport code identifying the airort to which the coupon tax applies.
                 * 
                 * @param airportCode
                 */
                public void setAirportCode(String airportCode) {
                    this.airportCode = airportCode;
                }

                /** 
                 * Get the 'ApplicableAmount' attribute value. The tax amount aplicable to the coupon as published in the IATA TTBS or other applicable filing mechanism. 
                 * 
                 * @return value
                 */
                public BigDecimal getApplicableAmount() {
                    return applicableAmount;
                }

                /** 
                 * Set the 'ApplicableAmount' attribute value. The tax amount aplicable to the coupon as published in the IATA TTBS or other applicable filing mechanism. 
                 * 
                 * @param applicableAmount
                 */
                public void setApplicableAmount(BigDecimal applicableAmount) {
                    this.applicableAmount = applicableAmount;
                }

                /** 
                 * Get the 'CurrencyType' attribute value. The ISO currency code representing the currency code in which the coupon tax applicable amount was published or filed in.  Use ISO 4217, three alpha code.
                 * 
                 * @return value
                 */
                public String getCurrencyType() {
                    return currencyType;
                }

                /** 
                 * Set the 'CurrencyType' attribute value. The ISO currency code representing the currency code in which the coupon tax applicable amount was published or filed in.  Use ISO 4217, three alpha code.
                 * 
                 * @param currencyType
                 */
                public void setCurrencyType(String currencyType) {
                    this.currencyType = currencyType;
                }

                /** 
                 * Get the 'ReportedAmount' attribute value. The tax amaount applicable to a coupon expressed in the currency of payment.
                 * 
                 * @return value
                 */
                public BigDecimal getReportedAmount() {
                    return reportedAmount;
                }

                /** 
                 * Set the 'ReportedAmount' attribute value. The tax amaount applicable to a coupon expressed in the currency of payment.
                 * 
                 * @param reportedAmount
                 */
                public void setReportedAmount(BigDecimal reportedAmount) {
                    this.reportedAmount = reportedAmount;
                }

                /** 
                 * Get the 'SegmentOriginAirportCode' attribute value. The origin airport code identifyng multiple segment taxes.
                 * 
                 * @return value
                 */
                public String getSegmentOriginAirportCode() {
                    return segmentOriginAirportCode;
                }

                /** 
                 * Set the 'SegmentOriginAirportCode' attribute value. The origin airport code identifyng multiple segment taxes.
                 * 
                 * @param segmentOriginAirportCode
                 */
                public void setSegmentOriginAirportCode(
                        String segmentOriginAirportCode) {
                    this.segmentOriginAirportCode = segmentOriginAirportCode;
                }

                /** 
                 * Get the 'SegmentDestAirportCode' attribute value. The destination airport code identifying multiple segment taxes.
                 * 
                 * @return value
                 */
                public String getSegmentDestAirportCode() {
                    return segmentDestAirportCode;
                }

                /** 
                 * Set the 'SegmentDestAirportCode' attribute value. The destination airport code identifying multiple segment taxes.
                 * 
                 * @param segmentDestAirportCode
                 */
                public void setSegmentDestAirportCode(
                        String segmentDestAirportCode) {
                    this.segmentDestAirportCode = segmentDestAirportCode;
                }
            }
            /** 
             * The airport or city code identifying an unticketed point which occurs between the coupon origin and destination. Unticketed point refers to a physical location at which the passenger makes a (potentially taxable) arrival and departure which does not appear in the good for Passage Area of the ticket. Used for the application of coupon level taxes.

             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UnticketedPointInfo" minOccurs="0" maxOccurs="5">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="CityAirportCode"/>
             *     &lt;xs:attribute type="xs:dateTime" use="optional" name="ArrivalDate"/>
             *     &lt;xs:attribute type="xs:dateTime" use="optional" name="DepartureDate"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="AirEquipType"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class UnticketedPointInfo implements Serializable
            {
                private String cityAirportCode;
                private Date arrivalDate;
                private Date departureDate;
                private String airEquipType;

                /** 
                 * Get the 'CityAirportCode' attribute value. The airport or city code identifying an unticketed point which occurs between the coupon origin and destination.
                 * 
                 * @return value
                 */
                public String getCityAirportCode() {
                    return cityAirportCode;
                }

                /** 
                 * Set the 'CityAirportCode' attribute value. The airport or city code identifying an unticketed point which occurs between the coupon origin and destination.
                 * 
                 * @param cityAirportCode
                 */
                public void setCityAirportCode(String cityAirportCode) {
                    this.cityAirportCode = cityAirportCode;
                }

                /** 
                 * Get the 'ArrivalDate' attribute value. The date and time of arrival in GMT at the unticketed point.
                 * 
                 * @return value
                 */
                public Date getArrivalDate() {
                    return arrivalDate;
                }

                /** 
                 * Set the 'ArrivalDate' attribute value. The date and time of arrival in GMT at the unticketed point.
                 * 
                 * @param arrivalDate
                 */
                public void setArrivalDate(Date arrivalDate) {
                    this.arrivalDate = arrivalDate;
                }

                /** 
                 * Get the 'DepartureDate' attribute value. The date and time of depature in GMT from the unticketed point.
                 * 
                 * @return value
                 */
                public Date getDepartureDate() {
                    return departureDate;
                }

                /** 
                 * Set the 'DepartureDate' attribute value. The date and time of depature in GMT from the unticketed point.
                 * 
                 * @param departureDate
                 */
                public void setDepartureDate(Date departureDate) {
                    this.departureDate = departureDate;
                }

                /** 
                 * Get the 'AirEquipType' attribute value. The standard code of the quipment used for the coupon flight departing from the unticketed point.
                 * 
                 * @return value
                 */
                public String getAirEquipType() {
                    return airEquipType;
                }

                /** 
                 * Set the 'AirEquipType' attribute value. The standard code of the quipment used for the coupon flight departing from the unticketed point.
                 * 
                 * @param airEquipType
                 */
                public void setAirEquipType(String airEquipType) {
                    this.airEquipType = airEquipType;
                }
            }
        }
    }
}
