
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Order Item-Level Time Limits.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeLimits">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="PaymentTimeLimit" minOccurs="0">
 *         &lt;!-- Reference to inner class PaymentTimeLimit -->
 *       &lt;/xs:element>
 *       &lt;xs:element ref="ns:PriceGuaranteeTimeLimit" minOccurs="0"/>
 *       &lt;xs:element ref="ns:DepositTimeLimit" minOccurs="0"/>
 *       &lt;xs:element ref="ns:TicketingTimeLimits" minOccurs="0"/>
 *       &lt;xs:element ref="ns:NamingTimeLimit" minOccurs="0"/>
 *       &lt;xs:element ref="ns:BilateralTimeLimits" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TimeLimits implements Serializable
{
    private PaymentTimeLimit paymentTimeLimit;
    private PriceGuaranteeTimeLimit priceGuaranteeTimeLimit;
    private DepositTimeLimit depositTimeLimit;
    private TicketingTimeLimits ticketingTimeLimits;
    private NamingTimeLimit namingTimeLimit;
    private BilateralTimeLimitsType bilateralTimeLimits;

    /** 
     * Get the 'PaymentTimeLimit' element value.
     * 
     * @return value
     */
    public PaymentTimeLimit getPaymentTimeLimit() {
        return paymentTimeLimit;
    }

    /** 
     * Set the 'PaymentTimeLimit' element value.
     * 
     * @param paymentTimeLimit
     */
    public void setPaymentTimeLimit(PaymentTimeLimit paymentTimeLimit) {
        this.paymentTimeLimit = paymentTimeLimit;
    }

    /** 
     * Get the 'PriceGuaranteeTimeLimit' element value.
     * 
     * @return value
     */
    public PriceGuaranteeTimeLimit getPriceGuaranteeTimeLimit() {
        return priceGuaranteeTimeLimit;
    }

    /** 
     * Set the 'PriceGuaranteeTimeLimit' element value.
     * 
     * @param priceGuaranteeTimeLimit
     */
    public void setPriceGuaranteeTimeLimit(
            PriceGuaranteeTimeLimit priceGuaranteeTimeLimit) {
        this.priceGuaranteeTimeLimit = priceGuaranteeTimeLimit;
    }

    /** 
     * Get the 'DepositTimeLimit' element value.
     * 
     * @return value
     */
    public DepositTimeLimit getDepositTimeLimit() {
        return depositTimeLimit;
    }

    /** 
     * Set the 'DepositTimeLimit' element value.
     * 
     * @param depositTimeLimit
     */
    public void setDepositTimeLimit(DepositTimeLimit depositTimeLimit) {
        this.depositTimeLimit = depositTimeLimit;
    }

    /** 
     * Get the 'TicketingTimeLimits' element value.
     * 
     * @return value
     */
    public TicketingTimeLimits getTicketingTimeLimits() {
        return ticketingTimeLimits;
    }

    /** 
     * Set the 'TicketingTimeLimits' element value.
     * 
     * @param ticketingTimeLimits
     */
    public void setTicketingTimeLimits(TicketingTimeLimits ticketingTimeLimits) {
        this.ticketingTimeLimits = ticketingTimeLimits;
    }

    /** 
     * Get the 'NamingTimeLimit' element value.
     * 
     * @return value
     */
    public NamingTimeLimit getNamingTimeLimit() {
        return namingTimeLimit;
    }

    /** 
     * Set the 'NamingTimeLimit' element value.
     * 
     * @param namingTimeLimit
     */
    public void setNamingTimeLimit(NamingTimeLimit namingTimeLimit) {
        this.namingTimeLimit = namingTimeLimit;
    }

    /** 
     * Get the 'BilateralTimeLimits' element value.
     * 
     * @return value
     */
    public BilateralTimeLimitsType getBilateralTimeLimits() {
        return bilateralTimeLimits;
    }

    /** 
     * Set the 'BilateralTimeLimits' element value.
     * 
     * @param bilateralTimeLimits
     */
    public void setBilateralTimeLimits(
            BilateralTimeLimitsType bilateralTimeLimits) {
        this.bilateralTimeLimits = bilateralTimeLimits;
    }
    /** 
     * Payment Time Limit value.
    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

    Notes:
    1. This is the deadline by which a commitment to pay must be made for the confirmed items in an offer as agreed witht he airline. The passenger meets this requirement by making complete payment for the order. 
    
    2. Payment Time Limit and Ticket Time Limit may be the same in most cases; however, Payment Time Limit expands to include ticketless transactions and other accountable documents.

    3. This time limit is at the OFFER-LEVEL and will apply to all (child) Offer Items.Although specified as mandatory in the BRD, there may be a case where Payment is already provided in the Order information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentTimeLimit" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CoreDateGrpType">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class PaymentTimeLimit extends CoreDateGrpType implements
        Serializable
    {
        private String refs;

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
