
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * TOTAL FARE TRANSACTION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalFareTransactionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="ns:FareAmountType" name="AmountType" minOccurs="0"/>
 *     &lt;xs:element type="ns:CouponPurposeListType" name="Purpose" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="EquivRate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ReissueSeqNbr"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TotalFareTransactionType implements Serializable
{
    private CurrencyAmountOptType amount;
    private FareAmountType amountType;
    private CouponPurposeListType purpose;
    private BigDecimal equivRate;
    private String reissueSeqNbr;

    /** 
     * Get the 'Amount' element value. Used to specify the total or total net amount.   Example 160 USD
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Used to specify the total or total net amount.   Example 160 USD
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'AmountType' element value. Total Fare Amount Type. Examples: ADC (Additional Charge); Bulk; IT (Tour Inclusive); NOADC (No Additional Charge)
     * 
     * @return value
     */
    public FareAmountType getAmountType() {
        return amountType;
    }

    /** 
     * Set the 'AmountType' element value. Total Fare Amount Type. Examples: ADC (Additional Charge); Bulk; IT (Tour Inclusive); NOADC (No Additional Charge)
     * 
     * @param amountType
     */
    public void setAmountType(FareAmountType amountType) {
        this.amountType = amountType;
    }

    /** 
     * Get the 'Purpose' element value. Total Fare Transaction Purpose. Example: Base, Net, Refund, Sell
     * 
     * @return value
     */
    public CouponPurposeListType getPurpose() {
        return purpose;
    }

    /** 
     * Set the 'Purpose' element value. Total Fare Transaction Purpose. Example: Base, Net, Refund, Sell
     * 
     * @param purpose
     */
    public void setPurpose(CouponPurposeListType purpose) {
        this.purpose = purpose;
    }

    /** 
     * Get the 'EquivRate' attribute value. Conversion rate. Example: 1.25

    Note: This is the BSR and/ or BBR used to convert the tax/fee/charge filed amount from the filed currency into the tax/fee/charge amount in currency of country of payment.
     * 
     * @return value
     */
    public BigDecimal getEquivRate() {
        return equivRate;
    }

    /** 
     * Set the 'EquivRate' attribute value. Conversion rate. Example: 1.25

    Note: This is the BSR and/ or BBR used to convert the tax/fee/charge filed amount from the filed currency into the tax/fee/charge amount in currency of country of payment.
     * 
     * @param equivRate
     */
    public void setEquivRate(BigDecimal equivRate) {
        this.equivRate = equivRate;
    }

    /** 
     * Get the 'ReissueSeqNbr' attribute value. Reissue Sequence Number. Example: 2

    Note: This is the sequence number assigned to each transaction amount.
     * 
     * @return value
     */
    public String getReissueSeqNbr() {
        return reissueSeqNbr;
    }

    /** 
     * Set the 'ReissueSeqNbr' attribute value. Reissue Sequence Number. Example: 2

    Note: This is the sequence number assigned to each transaction amount.
     * 
     * @param reissueSeqNbr
     */
    public void setReissueSeqNbr(String reissueSeqNbr) {
        this.reissueSeqNbr = reissueSeqNbr;
    }
}
