
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Airline Transfer/ Connection Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransferPreferencesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Connection">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element name="Codes" minOccurs="0">
 *                 &lt;!-- Reference to inner class Codes -->
 *               &lt;/xs:element>
 *               &lt;xs:element type="xs:string" name="MaxNumber" minOccurs="0"/>
 *               &lt;xs:element type="xs:string" name="MaxTime" minOccurs="0"/>
 *               &lt;xs:element type="xs:string" name="MinTime" minOccurs="0"/>
 *               &lt;xs:element name="Interline" minOccurs="0">
 *                 &lt;!-- Reference to inner class Interline -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *             &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Pricing" minOccurs="0">
 *           &lt;!-- Reference to inner class Pricing -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TransferPreferencesType extends AssociatedObjectBaseType implements
    Serializable
{
    private Codes codes;
    private String connectionMaxNumber;
    private String connectionMaxTime;
    private String connectionMinTime;
    private Interline interline;
    private String connectionRefs;
    private Pricing pricing;

    /** 
     * Get the 'Codes' element value. Connection(s).
     * 
     * @return value
     */
    public Codes getCodes() {
        return codes;
    }

    /** 
     * Set the 'Codes' element value. Connection(s).
     * 
     * @param codes
     */
    public void setCodes(Codes codes) {
        this.codes = codes;
    }

    /** 
     * Get the 'MaxNumber' element value. Maximum number of connections. Example: 2
     * 
     * @return value
     */
    public String getConnectionMaxNumber() {
        return connectionMaxNumber;
    }

    /** 
     * Set the 'MaxNumber' element value. Maximum number of connections. Example: 2
     * 
     * @param connectionMaxNumber
     */
    public void setConnectionMaxNumber(String connectionMaxNumber) {
        this.connectionMaxNumber = connectionMaxNumber;
    }

    /** 
     * Get the 'MaxTime' element value. Maximum connection time preference. Example: PT360M
     * 
     * @return value
     */
    public String getConnectionMaxTime() {
        return connectionMaxTime;
    }

    /** 
     * Set the 'MaxTime' element value. Maximum connection time preference. Example: PT360M
     * 
     * @param connectionMaxTime
     */
    public void setConnectionMaxTime(String connectionMaxTime) {
        this.connectionMaxTime = connectionMaxTime;
    }

    /** 
     * Get the 'MinTime' element value. Minimum connection time preference. Example: PT90M
     * 
     * @return value
     */
    public String getConnectionMinTime() {
        return connectionMinTime;
    }

    /** 
     * Set the 'MinTime' element value. Minimum connection time preference. Example: PT90M
     * 
     * @param connectionMinTime
     */
    public void setConnectionMinTime(String connectionMinTime) {
        this.connectionMinTime = connectionMinTime;
    }

    /** 
     * Get the 'Interline' element value. Connection(s).
     * 
     * @return value
     */
    public Interline getInterline() {
        return interline;
    }

    /** 
     * Set the 'Interline' element value. Connection(s).
     * 
     * @param interline
     */
    public void setInterline(Interline interline) {
        this.interline = interline;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getConnectionRefs() {
        return connectionRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param connectionRefs
     */
    public void setConnectionRefs(String connectionRefs) {
        this.connectionRefs = connectionRefs;
    }

    /** 
     * Get the 'Pricing' element value.
     * 
     * @return value
     */
    public Pricing getPricing() {
        return pricing;
    }

    /** 
     * Set the 'Pricing' element value.
     * 
     * @param pricing
     */
    public void setPricing(Pricing pricing) {
        this.pricing = pricing;
    }
    /** 
     * Airport Code(s) optional preference level.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Codes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Code" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Code -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Codes implements Serializable
    {
        private List<Code> codeList = new ArrayList<Code>();

        /** 
         * Get the list of 'Code' element items.
         * 
         * @return list
         */
        public List<Code> getCodeList() {
            return codeList;
        }

        /** 
         * Set the list of 'Code' element items.
         * 
         * @param list
         */
        public void setCodeList(List<Code> list) {
            codeList = list;
        }
        /** 
         * Airport Code. Example: TPA

        Encoding Scheme: IATA/ A4A Aiport or City Code
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Code implements Serializable
        {
            private String string;
            private PreferenceAttrGroup preferenceAttrGroup;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public PreferenceAttrGroup getPreferenceAttrGroup() {
                return preferenceAttrGroup;
            }

            /** 
             * Set the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @param preferenceAttrGroup
             */
            public void setPreferenceAttrGroup(
                    PreferenceAttrGroup preferenceAttrGroup) {
                this.preferenceAttrGroup = preferenceAttrGroup;
            }
        }
    }
    /** 
     * Flight connection preference - online/ interline
    Example: 0 (Online)

    Encoding Scheme: IATA PADIS Code List for data element 9885 - Online/ Interline Indicator
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Interline" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CodesetType">
     *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Interline extends CodesetType implements Serializable
    {
        private PreferenceAttrGroup preferenceAttrGroup;

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getPreferenceAttrGroup() {
            return preferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param preferenceAttrGroup
         */
        public void setPreferenceAttrGroup(
                PreferenceAttrGroup preferenceAttrGroup) {
            this.preferenceAttrGroup = preferenceAttrGroup;
        }
    }
    /** 
     * Contains indicator of when Connection Pricing should be applied. When true, Connection Pricing should be applied.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Pricing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ConnectionPricingInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Pricing implements Serializable
    {
        private Boolean connectionPricingInd;

        /** 
         * Get the 'ConnectionPricingInd' attribute value. When TRUE, apply selected CONNECTION PRICING.
         * 
         * @return value
         */
        public Boolean getConnectionPricingInd() {
            return connectionPricingInd;
        }

        /** 
         * Set the 'ConnectionPricingInd' attribute value. When TRUE, apply selected CONNECTION PRICING.
         * 
         * @param connectionPricingInd
         */
        public void setConnectionPricingInd(Boolean connectionPricingInd) {
            this.connectionPricingInd = connectionPricingInd;
        }
    }
}
