
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * SELLER: Travel Agency

 Creates shopping requests to Airlines on behalf of a customer and displays the subsequent product responses for review.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelAgency">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:TravelAgencyType">
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:AgentUserID"/>
 *         &lt;/xs:sequence>
 *         &lt;xs:attribute type="xs:string" use="optional" name="UserRole"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class TravelAgency extends TravelAgencyType implements Serializable
{
    private AgentUserIDType agentUserID;
    private String userRole;

    /** 
     * Get the 'AgentUserID' element value.
     * 
     * @return value
     */
    public AgentUserIDType getAgentUserID() {
        return agentUserID;
    }

    /** 
     * Set the 'AgentUserID' element value.
     * 
     * @param agentUserID
     */
    public void setAgentUserID(AgentUserIDType agentUserID) {
        this.agentUserID = agentUserID;
    }

    /** 
     * Get the 'UserRole' attribute value. Agent role. Example: Authorized User
     * 
     * @return value
     */
    public String getUserRole() {
        return userRole;
    }

    /** 
     * Set the 'UserRole' attribute value. Agent role. Example: Authorized User
     * 
     * @param userRole
     */
    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }
}
