
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A data type for Travel Time Preference.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelTimePreferencesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:decimal" name="TimeAmount"/>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *       &lt;xs:attribute type="xs:string" name="UOM"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelTimePreferencesType extends AssociatedObjectBaseType
    implements Serializable
{
    private BigDecimal timeAmount;
    private String application;
    private PreferenceAttrGroup preferenceAttrGroup;
    private String UOM;

    /** 
     * Get the 'TimeAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @return value
     */
    public BigDecimal getTimeAmount() {
        return timeAmount;
    }

    /** 
     * Set the 'TimeAmount' element value. Travel Distance (unit) Value.  Example: 20
     * 
     * @param timeAmount
     */
    public void setTimeAmount(BigDecimal timeAmount) {
        this.timeAmount = timeAmount;
    }

    /** 
     * Get the 'Application' element value. Travel time application.
    Examples: TotalJourneyTime, MaximumTravelTime
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Travel time application.
    Examples: TotalJourneyTime, MaximumTravelTime
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }

    /** 
     * Get the 'UOM' attribute value. Travel time unit of measure. Example: Minutes, Hours, days
     * 
     * @return value
     */
    public String getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' attribute value. Travel time unit of measure. Example: Minutes, Hours, days
     * 
     * @param UOM
     */
    public void setUOM(String UOM) {
        this.UOM = UOM;
    }
}
