
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Traveler Gender list constraint.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerGenderSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Male"/>
 *     &lt;xs:enumeration value="Female"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TravelerGenderSimpleType implements Serializable {
    MALE("Male"), FEMALE("Female"), UNKNOWN("Unknown"), OTHER("Other");
    private final String value;

    private TravelerGenderSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TravelerGenderSimpleType convert(String value) {
        for (TravelerGenderSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
