
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Associated Traveler(s) definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerInfoAssocType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:boolean" name="AllTravelerInd"/>
 *     &lt;xs:element ref="ns:TravelerReferences"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerInfoAssocType implements Serializable
{
    private int choiceSelect = -1;
    private static final int ALL_TRAVELER_IND_CHOICE = 0;
    private static final int TRAVELER_REFERENCES_CHOICE = 1;
    private boolean allTravelerInd;
    private TravelerReferences travelerReferences;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AllTravelerInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAllTravelerInd() {
        return choiceSelect == ALL_TRAVELER_IND_CHOICE;
    }

    /** 
     * Get the 'AllTravelerInd' element value. When TRUE, this Offer applies to all specified Travelers.
     * 
     * @return value
     */
    public boolean isAllTravelerInd() {
        return allTravelerInd;
    }

    /** 
     * Set the 'AllTravelerInd' element value. When TRUE, this Offer applies to all specified Travelers.
     * 
     * @param allTravelerInd
     */
    public void setAllTravelerInd(boolean allTravelerInd) {
        setChoiceSelect(ALL_TRAVELER_IND_CHOICE);
        this.allTravelerInd = allTravelerInd;
    }

    /** 
     * Check if TravelerReferences is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelerReferences() {
        return choiceSelect == TRAVELER_REFERENCES_CHOICE;
    }

    /** 
     * Get the 'TravelerReferences' element value. Association to multiple Traveler instance(s). Example: Traveler1 Traveler2

    Note: May be Recognized or Anonymous Traveler (by PTC) instance(s).
     * 
     * @return value
     */
    public TravelerReferences getTravelerReferences() {
        return travelerReferences;
    }

    /** 
     * Set the 'TravelerReferences' element value. Association to multiple Traveler instance(s). Example: Traveler1 Traveler2

    Note: May be Recognized or Anonymous Traveler (by PTC) instance(s).
     * 
     * @param travelerReferences
     */
    public void setTravelerReferences(TravelerReferences travelerReferences) {
        setChoiceSelect(TRAVELER_REFERENCES_CHOICE);
        this.travelerReferences = travelerReferences;
    }
}
