
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for SUMMARY Traveler representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerSummaryType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TravelerCoreType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Name">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element name="Surname">
 *                 &lt;xs:complexType>
 *                   &lt;xs:simpleContent>
 *                     &lt;xs:extension base="xs:string">
 *                       &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *                     &lt;/xs:extension>
 *                   &lt;/xs:simpleContent>
 *                 &lt;/xs:complexType>
 *               &lt;/xs:element>
 *               &lt;xs:element name="Given" minOccurs="0" maxOccurs="5">
 *                 &lt;!-- Reference to inner class Given -->
 *               &lt;/xs:element>
 *               &lt;xs:element type="xs:string" name="Title" minOccurs="0"/>
 *               &lt;xs:element name="SurnameSuffix" minOccurs="0"/>
 *               &lt;xs:element name="Middle" minOccurs="0" maxOccurs="3">
 *                 &lt;!-- Reference to inner class Middle -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *             &lt;xs:attributeGroup ref="ns:ObjectPolicyMetaAttrGroup"/>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="ProfileID" minOccurs="0">
 *           &lt;!-- Reference to inner class ProfileID -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TravelerSummaryType extends TravelerCoreType implements
    Serializable
{
    private String nameSurnameString;
    private String nameSurnameRefs;
    private List<Given> givenList = new ArrayList<Given>();
    private String nameTitle;
    private boolean nameSurnameSuffix;
    private List<Middle> middleList = new ArrayList<Middle>();
    private ObjectPolicyMetaAttrGroup nameObjectPolicyMetaAttrGroup;
    private ProfileID profileID;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getNameSurnameString() {
        return nameSurnameString;
    }

    /** 
     * Set the extension value.
     * 
     * @param nameSurnameString
     */
    public void setNameSurnameString(String nameSurnameString) {
        this.nameSurnameString = nameSurnameString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getNameSurnameRefs() {
        return nameSurnameRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param nameSurnameRefs
     */
    public void setNameSurnameRefs(String nameSurnameRefs) {
        this.nameSurnameRefs = nameSurnameRefs;
    }

    /** 
     * Get the list of 'Given' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @return list
     */
    public List<Given> getGivenList() {
        return givenList;
    }

    /** 
     * Set the list of 'Given' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @param list
     */
    public void setGivenList(List<Given> list) {
        givenList = list;
    }

    /** 
     * Get the 'Title' element value. Name Title. Examples: MR, MRS, DR
     * 
     * @return value
     */
    public String getNameTitle() {
        return nameTitle;
    }

    /** 
     * Set the 'Title' element value. Name Title. Examples: MR, MRS, DR
     * 
     * @param nameTitle
     */
    public void setNameTitle(String nameTitle) {
        this.nameTitle = nameTitle;
    }

    /** 
     * Check if the 'SurnameSuffix' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifNameSurnameSuffixPresent() {
        return nameSurnameSuffix;
    }

    /** 
     * Set flag for 'SurnameSuffix' element present.
     * 
     * @param nameSurnameSuffix
     */
    public void flagNameSurnameSuffixPresent(boolean nameSurnameSuffix) {
        this.nameSurnameSuffix = nameSurnameSuffix;
    }

    /** 
     * Get the list of 'Middle' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @return list
     */
    public List<Middle> getMiddleList() {
        return middleList;
    }

    /** 
     * Set the list of 'Middle' element items. Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * @param list
     */
    public void setMiddleList(List<Middle> list) {
        middleList = list;
    }

    /** 
     * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectPolicyMetaAttrGroup getNameObjectPolicyMetaAttrGroup() {
        return nameObjectPolicyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @param nameObjectPolicyMetaAttrGroup
     */
    public void setNameObjectPolicyMetaAttrGroup(
            ObjectPolicyMetaAttrGroup nameObjectPolicyMetaAttrGroup) {
        this.nameObjectPolicyMetaAttrGroup = nameObjectPolicyMetaAttrGroup;
    }

    /** 
     * Get the 'ProfileID' element value.
     * 
     * @return value
     */
    public ProfileID getProfileID() {
        return profileID;
    }

    /** 
     * Set the 'ProfileID' element value.
     * 
     * @param profileID
     */
    public void setProfileID(ProfileID profileID) {
        this.profileID = profileID;
    }
    /** 
     * Given name, first name or names
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Given" minOccurs="0" maxOccurs="5">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Given implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Middle name or initial.  Examples: G, GEORGE
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Middle" minOccurs="0" maxOccurs="3">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Middle implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
    /** 
     * Traveler profile ID.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileID" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class ProfileID implements Serializable
    {
        private String string;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
