
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Traveler information.

 Notes:
 1. A combination of Anonymous and/ or Recognized Traveler information may be specified.

 2. Anonymous Traveler includes a Passenger Type Code and quantity of passengers of this type.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Travelers">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Traveler" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class Traveler -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Travelers implements Serializable
{
    private List<Traveler> travelerList = new ArrayList<Traveler>();

    /** 
     * Get the list of 'Traveler' element items.
     * 
     * @return list
     */
    public List<Traveler> getTravelerList() {
        return travelerList;
    }

    /** 
     * Set the list of 'Traveler' element items.
     * 
     * @param list
     */
    public void setTravelerList(List<Traveler> list) {
        travelerList = list;
    }
    /** 
     * Anonymous or Recognized Traveler information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Traveler" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AnonymousTraveler" minOccurs="0"/>
     *       &lt;xs:element ref="ns:RecognizedTraveler" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Traveler implements Serializable
    {
        private TravelerCoreType anonymousTraveler;
        private TravelerDetailType recognizedTraveler;

        /** 
         * Get the 'AnonymousTraveler' element value.
         * 
         * @return value
         */
        public TravelerCoreType getAnonymousTraveler() {
            return anonymousTraveler;
        }

        /** 
         * Set the 'AnonymousTraveler' element value.
         * 
         * @param anonymousTraveler
         */
        public void setAnonymousTraveler(TravelerCoreType anonymousTraveler) {
            this.anonymousTraveler = anonymousTraveler;
        }

        /** 
         * Get the 'RecognizedTraveler' element value.
         * 
         * @return value
         */
        public TravelerDetailType getRecognizedTraveler() {
            return recognizedTraveler;
        }

        /** 
         * Set the 'RecognizedTraveler' element value.
         * 
         * @param recognizedTraveler
         */
        public void setRecognizedTraveler(TravelerDetailType recognizedTraveler) {
            this.recognizedTraveler = recognizedTraveler;
        }
    }
}
