
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * 
 A data type for NDC Transaction Processing Status contextual list. Example: Complete, InComplete, Unknown

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TrxProcessingListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Complete"/>
 *     &lt;xs:enumeration value="InComplete"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TrxProcessingListType implements Serializable {
    COMPLETE("Complete"), IN_COMPLETE("InComplete"), UNKNOWN("Unknown");
    private final String value;

    private TrxProcessingListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TrxProcessingListType convert(String value) {
        for (TrxProcessingListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
