
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information relating to prepayment vouchers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Voucher">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
 *       &lt;xs:element name="EffectiveExpireDate" minOccurs="0">
 *         &lt;!-- Reference to inner class EffectiveExpireDate -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Name" minOccurs="0">
 *         &lt;!-- Reference to inner class Name -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Voucher implements Serializable
{
    private String number;
    private EffectiveExpireDate effectiveExpireDate;
    private Name name;

    /** 
     * Get the 'Number' element value. Voucher ID or Number. Example: XX12345
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value. Voucher ID or Number. Example: XX12345
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'EffectiveExpireDate' element value.
     * 
     * @return value
     */
    public EffectiveExpireDate getEffectiveExpireDate() {
        return effectiveExpireDate;
    }

    /** 
     * Set the 'EffectiveExpireDate' element value.
     * 
     * @param effectiveExpireDate
     */
    public void setEffectiveExpireDate(EffectiveExpireDate effectiveExpireDate) {
        this.effectiveExpireDate = effectiveExpireDate;
    }

    /** 
     * Get the 'Name' element value.
     * 
     * @return value
     */
    public Name getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value.
     * 
     * @param name
     */
    public void setName(Name name) {
        this.name = name;
    }
    /** 
     * Voucher Effective and/ or Expiration date(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveExpireDate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:date" name="Effective" minOccurs="0"/>
     *       &lt;xs:element type="xs:date" name="Expiration" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EffectiveExpireDate implements Serializable
    {
        private Date effective;
        private Date expiration;

        /** 
         * Get the 'Effective' element value. Voucher Effective Date. Example: 2017-01-13
         * 
         * @return value
         */
        public Date getEffective() {
            return effective;
        }

        /** 
         * Set the 'Effective' element value. Voucher Effective Date. Example: 2017-01-13
         * 
         * @param effective
         */
        public void setEffective(Date effective) {
            this.effective = effective;
        }

        /** 
         * Get the 'Expiration' element value. Voucher Expiration date. Example: 2017-06-13
         * 
         * @return value
         */
        public Date getExpiration() {
            return expiration;
        }

        /** 
         * Set the 'Expiration' element value. Voucher Expiration date. Example: 2017-06-13
         * 
         * @param expiration
         */
        public void setExpiration(Date expiration) {
            this.expiration = expiration;
        }
    }
    /** 
     * Passenger Name information.

    Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Name" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Surname">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="Given" minOccurs="0" maxOccurs="5">
     *         &lt;!-- Reference to inner class Given -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Title" minOccurs="0"/>
     *       &lt;xs:element name="SurnameSuffix" minOccurs="0"/>
     *       &lt;xs:element name="Middle" minOccurs="0" maxOccurs="3">
     *         &lt;!-- Reference to inner class Middle -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjectPolicyMetaAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Name implements Serializable
    {
        private String surnameString;
        private String surnameRefs;
        private List<Given> givenList = new ArrayList<Given>();
        private String title;
        private boolean surnameSuffix;
        private List<Middle> middleList = new ArrayList<Middle>();
        private ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getSurnameString() {
            return surnameString;
        }

        /** 
         * Set the extension value.
         * 
         * @param surnameString
         */
        public void setSurnameString(String surnameString) {
            this.surnameString = surnameString;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getSurnameRefs() {
            return surnameRefs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param surnameRefs
         */
        public void setSurnameRefs(String surnameRefs) {
            this.surnameRefs = surnameRefs;
        }

        /** 
         * Get the list of 'Given' element items.
         * 
         * @return list
         */
        public List<Given> getGivenList() {
            return givenList;
        }

        /** 
         * Set the list of 'Given' element items.
         * 
         * @param list
         */
        public void setGivenList(List<Given> list) {
            givenList = list;
        }

        /** 
         * Get the 'Title' element value. Name Title. Examples: MR, MRS, DR
         * 
         * @return value
         */
        public String getTitle() {
            return title;
        }

        /** 
         * Set the 'Title' element value. Name Title. Examples: MR, MRS, DR
         * 
         * @param title
         */
        public void setTitle(String title) {
            this.title = title;
        }

        /** 
         * Check if the 'SurnameSuffix' element is present.
         * 
         * @return <code>true</code> if present, <code>false</code> if not
         */
        public boolean ifSurnameSuffixPresent() {
            return surnameSuffix;
        }

        /** 
         * Set flag for 'SurnameSuffix' element present.
         * 
         * @param surnameSuffix
         */
        public void flagSurnameSuffixPresent(boolean surnameSuffix) {
            this.surnameSuffix = surnameSuffix;
        }

        /** 
         * Get the list of 'Middle' element items.
         * 
         * @return list
         */
        public List<Middle> getMiddleList() {
            return middleList;
        }

        /** 
         * Set the list of 'Middle' element items.
         * 
         * @param list
         */
        public void setMiddleList(List<Middle> list) {
            middleList = list;
        }

        /** 
         * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public ObjectPolicyMetaAttrGroup getObjectPolicyMetaAttrGroup() {
            return objectPolicyMetaAttrGroup;
        }

        /** 
         * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
         * 
         * @param objectPolicyMetaAttrGroup
         */
        public void setObjectPolicyMetaAttrGroup(
                ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup) {
            this.objectPolicyMetaAttrGroup = objectPolicyMetaAttrGroup;
        }
        /** 
         * Given name, first name or names
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Given" minOccurs="0" maxOccurs="5">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Given implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
        /** 
         * Middle name or initial.  Examples: G, GEORGE
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Middle" minOccurs="0" maxOccurs="3">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Middle implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
}
