
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;

/** 
 * VOUCHER Payment Form definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VoucherMethodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
 *     &lt;xs:element name="EffectiveExpireDate" minOccurs="0">
 *       &lt;!-- Reference to inner class EffectiveExpireDate -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="RemainingValue" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class VoucherMethodType implements Serializable
{
    private String number;
    private EffectiveExpireDate effectiveExpireDate;
    private CurrencyAmountOptType remainingValue;
    private String refs;

    /** 
     * Get the 'Number' element value. Voucher ID or Number. Example: XX12345
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value. Voucher ID or Number. Example: XX12345
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'EffectiveExpireDate' element value.
     * 
     * @return value
     */
    public EffectiveExpireDate getEffectiveExpireDate() {
        return effectiveExpireDate;
    }

    /** 
     * Set the 'EffectiveExpireDate' element value.
     * 
     * @param effectiveExpireDate
     */
    public void setEffectiveExpireDate(EffectiveExpireDate effectiveExpireDate) {
        this.effectiveExpireDate = effectiveExpireDate;
    }

    /** 
     * Get the 'RemainingValue' element value. Remaining Amount on Voucher.
     * 
     * @return value
     */
    public CurrencyAmountOptType getRemainingValue() {
        return remainingValue;
    }

    /** 
     * Set the 'RemainingValue' element value. Remaining Amount on Voucher.
     * 
     * @param remainingValue
     */
    public void setRemainingValue(CurrencyAmountOptType remainingValue) {
        this.remainingValue = remainingValue;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Voucher Effective and/ or Expiration date(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectiveExpireDate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:date" name="Effective" minOccurs="0"/>
     *       &lt;xs:element type="xs:date" name="Expiration" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EffectiveExpireDate implements Serializable
    {
        private Date effective;
        private Date expiration;

        /** 
         * Get the 'Effective' element value. Voucher Effective Date. Example: 2017-01-13
         * 
         * @return value
         */
        public Date getEffective() {
            return effective;
        }

        /** 
         * Set the 'Effective' element value. Voucher Effective Date. Example: 2017-01-13
         * 
         * @param effective
         */
        public void setEffective(Date effective) {
            this.effective = effective;
        }

        /** 
         * Get the 'Expiration' element value. Voucher Expiration date. Example: 2017-06-13
         * 
         * @return value
         */
        public Date getExpiration() {
            return expiration;
        }

        /** 
         * Set the 'Expiration' element value. Voucher Expiration date. Example: 2017-06-13
         * 
         * @param expiration
         */
        public void setExpiration(Date expiration) {
            this.expiration = expiration;
        }
    }
}
