
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * SEAT MAP WING POSITION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WingPositionType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Rows" maxOccurs="2">
 *           &lt;!-- Reference to inner class Rows -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:SegmentReference" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class WingPositionType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<Rows> rowList = new ArrayList<Rows>();
    private SegmentReference segmentReference;

    /** 
     * Get the list of 'Rows' element items.
     * 
     * @return list
     */
    public List<Rows> getRowList() {
        return rowList;
    }

    /** 
     * Set the list of 'Rows' element items.
     * 
     * @param list
     */
    public void setRowList(List<Rows> list) {
        rowList = list;
    }

    /** 
     * Get the 'SegmentReference' element value.
     * 
     * @return value
     */
    public SegmentReference getSegmentReference() {
        return segmentReference;
    }

    /** 
     * Set the 'SegmentReference' element value.
     * 
     * @param segmentReference
     */
    public void setSegmentReference(SegmentReference segmentReference) {
        this.segmentReference = segmentReference;
    }
    /** 
     * Row detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rows" maxOccurs="2">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="First"/>
     *           &lt;xs:element type="xs:string" name="Last"/>
     *           &lt;xs:element ref="ns:SegmentReference" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="UpperDeckInd"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Rows extends AssociatedObjectBaseType implements
        Serializable
    {
        private String first;
        private String last;
        private SegmentReference segmentReference;
        private Boolean upperDeckInd;

        /** 
         * Get the 'First' element value. First row number.
        Example: 15
         * 
         * @return value
         */
        public String getFirst() {
            return first;
        }

        /** 
         * Set the 'First' element value. First row number.
        Example: 15
         * 
         * @param first
         */
        public void setFirst(String first) {
            this.first = first;
        }

        /** 
         * Get the 'Last' element value. Last row number.
        Example: 16
         * 
         * @return value
         */
        public String getLast() {
            return last;
        }

        /** 
         * Set the 'Last' element value. Last row number.
        Example: 16
         * 
         * @param last
         */
        public void setLast(String last) {
            this.last = last;
        }

        /** 
         * Get the 'SegmentReference' element value.
         * 
         * @return value
         */
        public SegmentReference getSegmentReference() {
            return segmentReference;
        }

        /** 
         * Set the 'SegmentReference' element value.
         * 
         * @param segmentReference
         */
        public void setSegmentReference(SegmentReference segmentReference) {
            this.segmentReference = segmentReference;
        }

        /** 
         * Get the 'UpperDeckInd' attribute value. When TRUE, this section is on the upper deck of an aircraft.

        Note: If being used in a Seat Map, this may indicate that a separate seatmap graphic is requested.
         * 
         * @return value
         */
        public Boolean getUpperDeckInd() {
            return upperDeckInd;
        }

        /** 
         * Set the 'UpperDeckInd' attribute value. When TRUE, this section is on the upper deck of an aircraft.

        Note: If being used in a Seat Map, this may indicate that a separate seatmap graphic is requested.
         * 
         * @param upperDeckInd
         */
        public void setUpperDeckInd(Boolean upperDeckInd) {
            this.upperDeckInd = upperDeckInd;
        }
    }
}
