
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="First"/>
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="Economy"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CabinType implements Serializable {
    /** 
     * First class compartment.
     */
    FIRST("First"), /** 
                     * Business class compartment.
                     */
    BUSINESS("Business"), /** 
                           * Economy (or sometimes referred to as Coach) class compartment.
                           */
    ECONOMY("Economy");
    private final String value;

    private CabinType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CabinType convert(String value) {
        for (CabinType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
