
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreditCard.Misc">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code"/>
 *     &lt;xs:element type="xs:string" name="Number"/>
 *     &lt;xs:element type="xs:string" name="ExpiryDate"/>
 *     &lt;xs:element type="xs:string" name="SecurityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ApprovalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ExtendedPayCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EffectiveDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CompressedNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="transactionID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CreditCardMisc implements Serializable
{
    private String code;
    private String number;
    private String expiryDate;
    private String securityCode;
    private String approvalCode;
    private String extendedPayCode;
    private String effectiveDate;
    private String compressedNumber;
    private String transactionID;

    /** 
     * Get the 'Code' element value. A card type used for paying a service or item (e.g, MC, VI, BT, BA, etc)
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. A card type used for paying a service or item (e.g, MC, VI, BT, BA, etc)
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Number' element value. An account number associated to card type
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value. An account number associated to card type
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'ExpiryDate' element value. Credit card expiration date
     * 
     * @return value
     */
    public String getExpiryDate() {
        return expiryDate;
    }

    /** 
     * Set the 'ExpiryDate' element value. Credit card expiration date
     * 
     * @param expiryDate
     */
    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    /** 
     * Get the 'SecurityCode' element value. Security card code of the payment method used (CSC)
     * 
     * @return value
     */
    public String getSecurityCode() {
        return securityCode;
    }

    /** 
     * Set the 'SecurityCode' element value. Security card code of the payment method used (CSC)
     * 
     * @param securityCode
     */
    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    /** 
     * Get the 'ApprovalCode' element value. An approval code associated to payment.
     * 
     * @return value
     */
    public String getApprovalCode() {
        return approvalCode;
    }

    /** 
     * Set the 'ApprovalCode' element value. An approval code associated to payment.
     * 
     * @param approvalCode
     */
    public void setApprovalCode(String approvalCode) {
        this.approvalCode = approvalCode;
    }

    /** 
     * Get the 'ExtendedPayCode' element value. A code associated to the extended payment of the credit card used.
     * 
     * @return value
     */
    public String getExtendedPayCode() {
        return extendedPayCode;
    }

    /** 
     * Set the 'ExtendedPayCode' element value. A code associated to the extended payment of the credit card used.
     * 
     * @param extendedPayCode
     */
    public void setExtendedPayCode(String extendedPayCode) {
        this.extendedPayCode = extendedPayCode;
    }

    /** 
     * Get the 'EffectiveDate' element value. required if Maestro CC
     * 
     * @return value
     */
    public String getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. required if Maestro CC
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'CompressedNumber' element value. required if Maestro CC
     * 
     * @return value
     */
    public String getCompressedNumber() {
        return compressedNumber;
    }

    /** 
     * Set the 'CompressedNumber' element value. required if Maestro CC
     * 
     * @param compressedNumber
     */
    public void setCompressedNumber(String compressedNumber) {
        this.compressedNumber = compressedNumber;
    }

    /** 
     * Get the 'transactionID' attribute value.
     * 
     * @return value
     */
    public String getTransactionID() {
        return transactionID;
    }

    /** 
     * Set the 'transactionID' attribute value.
     * 
     * @param transactionID
     */
    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
    }
}
