
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * 12/10/2010 - dmh - added VEF
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyCodeList">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ADP"/>
 *     &lt;xs:enumeration value="AED"/>
 *     &lt;xs:enumeration value="AFA"/>
 *     &lt;xs:enumeration value="ALL"/>
 *     &lt;xs:enumeration value="AMD"/>
 *     &lt;xs:enumeration value="ANG"/>
 *     &lt;xs:enumeration value="AON"/>
 *     &lt;xs:enumeration value="AOR"/>
 *     &lt;xs:enumeration value="ARS"/>
 *     &lt;xs:enumeration value="ATS"/>
 *     &lt;xs:enumeration value="AUD"/>
 *     &lt;xs:enumeration value="AWG"/>
 *     &lt;xs:enumeration value="AZM"/>
 *     &lt;xs:enumeration value="BAM"/>
 *     &lt;xs:enumeration value="BBD"/>
 *     &lt;xs:enumeration value="BDT"/>
 *     &lt;xs:enumeration value="BEF"/>
 *     &lt;xs:enumeration value="BGL"/>
 *     &lt;xs:enumeration value="BGN"/>
 *     &lt;xs:enumeration value="BHD"/>
 *     &lt;xs:enumeration value="BIF"/>
 *     &lt;xs:enumeration value="BMD"/>
 *     &lt;xs:enumeration value="BND"/>
 *     &lt;xs:enumeration value="BRL"/>
 *     &lt;xs:enumeration value="BSD"/>
 *     &lt;xs:enumeration value="BTN"/>
 *     &lt;xs:enumeration value="BWP"/>
 *     &lt;xs:enumeration value="BYR"/>
 *     &lt;xs:enumeration value="BZD"/>
 *     &lt;xs:enumeration value="CAD"/>
 *     &lt;xs:enumeration value="CDF"/>
 *     &lt;xs:enumeration value="CHF"/>
 *     &lt;xs:enumeration value="CLF"/>
 *     &lt;xs:enumeration value="CLP"/>
 *     &lt;xs:enumeration value="CNY"/>
 *     &lt;xs:enumeration value="COP"/>
 *     &lt;xs:enumeration value="CRC"/>
 *     &lt;xs:enumeration value="CUP"/>
 *     &lt;xs:enumeration value="CVE"/>
 *     &lt;xs:enumeration value="CYP"/>
 *     &lt;xs:enumeration value="CZK"/>
 *     &lt;xs:enumeration value="DEM"/>
 *     &lt;xs:enumeration value="DJF"/>
 *     &lt;xs:enumeration value="DKK"/>
 *     &lt;xs:enumeration value="DOP"/>
 *     &lt;xs:enumeration value="DZD"/>
 *     &lt;xs:enumeration value="ECS"/>
 *     &lt;xs:enumeration value="ECV"/>
 *     &lt;xs:enumeration value="EEK"/>
 *     &lt;xs:enumeration value="EGP"/>
 *     &lt;xs:enumeration value="ERN"/>
 *     &lt;xs:enumeration value="ESP"/>
 *     &lt;xs:enumeration value="ETB"/>
 *     &lt;xs:enumeration value="EUR"/>
 *     &lt;xs:enumeration value="FIM"/>
 *     &lt;xs:enumeration value="FJD"/>
 *     &lt;xs:enumeration value="FKP"/>
 *     &lt;xs:enumeration value="FRF"/>
 *     &lt;xs:enumeration value="GBP"/>
 *     &lt;xs:enumeration value="GEL"/>
 *     &lt;xs:enumeration value="GHC"/>
 *     &lt;xs:enumeration value="GIP"/>
 *     &lt;xs:enumeration value="GMD"/>
 *     &lt;xs:enumeration value="GNF"/>
 *     &lt;xs:enumeration value="GRD"/>
 *     &lt;xs:enumeration value="GTQ"/>
 *     &lt;xs:enumeration value="GWP"/>
 *     &lt;xs:enumeration value="GYD"/>
 *     &lt;xs:enumeration value="HKD"/>
 *     &lt;xs:enumeration value="HNL"/>
 *     &lt;xs:enumeration value="HRK"/>
 *     &lt;xs:enumeration value="HTG"/>
 *     &lt;xs:enumeration value="HUF"/>
 *     &lt;xs:enumeration value="IDR"/>
 *     &lt;xs:enumeration value="IEP"/>
 *     &lt;xs:enumeration value="ILS"/>
 *     &lt;xs:enumeration value="INR"/>
 *     &lt;xs:enumeration value="IQD"/>
 *     &lt;xs:enumeration value="IRR"/>
 *     &lt;xs:enumeration value="ISK"/>
 *     &lt;xs:enumeration value="ITL"/>
 *     &lt;xs:enumeration value="JMD"/>
 *     &lt;xs:enumeration value="JOD"/>
 *     &lt;xs:enumeration value="JPY"/>
 *     &lt;xs:enumeration value="KES"/>
 *     &lt;xs:enumeration value="KGS"/>
 *     &lt;xs:enumeration value="KHR"/>
 *     &lt;xs:enumeration value="KMF"/>
 *     &lt;xs:enumeration value="KPW"/>
 *     &lt;xs:enumeration value="KRW"/>
 *     &lt;xs:enumeration value="KWD"/>
 *     &lt;xs:enumeration value="KYD"/>
 *     &lt;xs:enumeration value="KZT"/>
 *     &lt;xs:enumeration value="LAK"/>
 *     &lt;xs:enumeration value="LBP"/>
 *     &lt;xs:enumeration value="LKR"/>
 *     &lt;xs:enumeration value="LRD"/>
 *     &lt;xs:enumeration value="LSL"/>
 *     &lt;xs:enumeration value="LTL"/>
 *     &lt;xs:enumeration value="LUF"/>
 *     &lt;xs:enumeration value="LVL"/>
 *     &lt;xs:enumeration value="LYD"/>
 *     &lt;xs:enumeration value="MAD"/>
 *     &lt;xs:enumeration value="MDL"/>
 *     &lt;xs:enumeration value="MGF"/>
 *     &lt;xs:enumeration value="MKD"/>
 *     &lt;xs:enumeration value="MMK"/>
 *     &lt;xs:enumeration value="MNT"/>
 *     &lt;xs:enumeration value="MOP"/>
 *     &lt;xs:enumeration value="MRO"/>
 *     &lt;xs:enumeration value="MTL"/>
 *     &lt;xs:enumeration value="MUR"/>
 *     &lt;xs:enumeration value="MVR"/>
 *     &lt;xs:enumeration value="MWK"/>
 *     &lt;xs:enumeration value="MXN"/>
 *     &lt;xs:enumeration value="MXV"/>
 *     &lt;xs:enumeration value="MYR"/>
 *     &lt;xs:enumeration value="MZM"/>
 *     &lt;xs:enumeration value="NAD"/>
 *     &lt;xs:enumeration value="NGN"/>
 *     &lt;xs:enumeration value="NIO"/>
 *     &lt;xs:enumeration value="NLG"/>
 *     &lt;xs:enumeration value="NOK"/>
 *     &lt;xs:enumeration value="NPR"/>
 *     &lt;xs:enumeration value="NZD"/>
 *     &lt;xs:enumeration value="OMR"/>
 *     &lt;xs:enumeration value="PAB"/>
 *     &lt;xs:enumeration value="PEN"/>
 *     &lt;xs:enumeration value="PGK"/>
 *     &lt;xs:enumeration value="PHP"/>
 *     &lt;xs:enumeration value="PKR"/>
 *     &lt;xs:enumeration value="PLN"/>
 *     &lt;xs:enumeration value="PTE"/>
 *     &lt;xs:enumeration value="PYG"/>
 *     &lt;xs:enumeration value="QAR"/>
 *     &lt;xs:enumeration value="ROL"/>
 *     &lt;xs:enumeration value="RUB"/>
 *     &lt;xs:enumeration value="RUR"/>
 *     &lt;xs:enumeration value="RWF"/>
 *     &lt;xs:enumeration value="SAR"/>
 *     &lt;xs:enumeration value="SBD"/>
 *     &lt;xs:enumeration value="SCR"/>
 *     &lt;xs:enumeration value="SDD"/>
 *     &lt;xs:enumeration value="SEK"/>
 *     &lt;xs:enumeration value="SGD"/>
 *     &lt;xs:enumeration value="SHP"/>
 *     &lt;xs:enumeration value="SIT"/>
 *     &lt;xs:enumeration value="SKK"/>
 *     &lt;xs:enumeration value="SLL"/>
 *     &lt;xs:enumeration value="SOS"/>
 *     &lt;xs:enumeration value="SRG"/>
 *     &lt;xs:enumeration value="STD"/>
 *     &lt;xs:enumeration value="SVC"/>
 *     &lt;xs:enumeration value="SYP"/>
 *     &lt;xs:enumeration value="SZL"/>
 *     &lt;xs:enumeration value="THB"/>
 *     &lt;xs:enumeration value="TJR"/>
 *     &lt;xs:enumeration value="TJS"/>
 *     &lt;xs:enumeration value="TMM"/>
 *     &lt;xs:enumeration value="TND"/>
 *     &lt;xs:enumeration value="TOP"/>
 *     &lt;xs:enumeration value="TPE"/>
 *     &lt;xs:enumeration value="TRL"/>
 *     &lt;xs:enumeration value="TTD"/>
 *     &lt;xs:enumeration value="TWD"/>
 *     &lt;xs:enumeration value="TZS"/>
 *     &lt;xs:enumeration value="UAH"/>
 *     &lt;xs:enumeration value="UGX"/>
 *     &lt;xs:enumeration value="USD"/>
 *     &lt;xs:enumeration value="USN"/>
 *     &lt;xs:enumeration value="USS"/>
 *     &lt;xs:enumeration value="UYU"/>
 *     &lt;xs:enumeration value="UZS"/>
 *     &lt;xs:enumeration value="VEB"/>
 *     &lt;xs:enumeration value="VEF"/>
 *     &lt;xs:enumeration value="VND"/>
 *     &lt;xs:enumeration value="VUV"/>
 *     &lt;xs:enumeration value="WST"/>
 *     &lt;xs:enumeration value="XAF"/>
 *     &lt;xs:enumeration value="XAG"/>
 *     &lt;xs:enumeration value="XAU"/>
 *     &lt;xs:enumeration value="XBA"/>
 *     &lt;xs:enumeration value="XBB"/>
 *     &lt;xs:enumeration value="XBC"/>
 *     &lt;xs:enumeration value="XBD"/>
 *     &lt;xs:enumeration value="XCD"/>
 *     &lt;xs:enumeration value="XDR"/>
 *     &lt;xs:enumeration value="XFO"/>
 *     &lt;xs:enumeration value="XFU"/>
 *     &lt;xs:enumeration value="XOF"/>
 *     &lt;xs:enumeration value="XPD"/>
 *     &lt;xs:enumeration value="XPF"/>
 *     &lt;xs:enumeration value="XPT"/>
 *     &lt;xs:enumeration value="XTS"/>
 *     &lt;xs:enumeration value="XXX"/>
 *     &lt;xs:enumeration value="YER"/>
 *     &lt;xs:enumeration value="YUM"/>
 *     &lt;xs:enumeration value="ZAL"/>
 *     &lt;xs:enumeration value="ZAR"/>
 *     &lt;xs:enumeration value="ZMK"/>
 *     &lt;xs:enumeration value="ZRN"/>
 *     &lt;xs:enumeration value="ZWD"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CurrencyCodeList implements Serializable {
    /** 
     * Andorran Peseta: Andorra
     */
    ADP, /** 
          * UAE Dirham: United Arab Emirates
          */
    AED, /** 
          * Afghani: Afghanistan
          */
    AFA, /** 
          * Lek: Albania
          */
    ALL, /** 
          * Armenian Dram: Armenia
          */
    AMD, /** 
          * Antillian Guilder: Netherlands Antilles
          */
    ANG, /** 
          * New Kwanza: Angola
          */
    AON, /** 
          * Kwanza Reajustado: Angola
          */
    AOR, /** 
          * Argentine Peso: Argentina
          */
    ARS, /** 
          * Schilling: Austria
          */
    ATS, /** 
          * Australian Dollar: Australia, Christmas Island, Cocos (Keeling) Islands, Heard and Mcdonald Islands, Kiribati, Nauru, Norfolk Island, Tuvalu
          */
    AUD, /** 
          * Aruban Guilder: Aruba
          */
    AWG, /** 
          * Azerbaijanian Manat: Azerbaijan
          */
    AZM, /** 
          * Convertible Marks: Bosnia and Herzegovina
          */
    BAM, /** 
          * Barbados Dollar: Barbados
          */
    BBD, /** 
          * Taka: Bangladesh
          */
    BDT, /** 
          * Belgian Franc: Belgium
          */
    BEF, /** 
          * Lev: Bulgaria
          */
    BGL, /** 
          * Bulgarian LEV: Bulgaria
          */
    BGN, /** 
          * Bahraini Dinar: Bahrain
          */
    BHD, /** 
          * Burundi Franc: Burundi
          */
    BIF, /** 
          * Bermudian Dollar: Bermuda
          */
    BMD, /** 
          * Brunei Dollar: Brunei Darussalam
          */
    BND, /** 
          * Brazilian Real: Brazil
          */
    BRL, /** 
          * Bahamian Dollar: Bahamas
          */
    BSD, /** 
          * Ngultrum: Bhutan
          */
    BTN, /** 
          * Pula: Botswana
          */
    BWP, /** 
          * Belarussian Ruble: Belarus
          */
    BYR, /** 
          * Belize Dollar: Belize
          */
    BZD, /** 
          * Canadian Dollar: Canada
          */
    CAD, /** 
          * Franc Congolais: Congo, The Democratic Republic Of
          */
    CDF, /** 
          * Swiss Franc: Liechtenstein, Switzerland
          */
    CHF, /** 
          * Unidades de fomento: Chile
          */
    CLF, /** 
          * Chilean Peso: Chile
          */
    CLP, /** 
          * Yuan Renminbi: China
          */
    CNY, /** 
          * Colombian Peso: Colombia
          */
    COP, /** 
          * Costa Rican Colon: Costa Rica
          */
    CRC, /** 
          * Cuban Peso: Cuba
          */
    CUP, /** 
          * Cape Verde Escudo: Cape Verde
          */
    CVE, /** 
          * Cyprus Pound: Cyprus
          */
    CYP, /** 
          * Czech Koruna: Czech Republic
          */
    CZK, /** 
          * Deutsche Mark: Germany
          */
    DEM, /** 
          * Djibouti Franc: Djibouti
          */
    DJF, /** 
          * Danish Krone: Denmark, Faeroe Islands, Greenland
          */
    DKK, /** 
          * Dominican Peso: Dominican Republic
          */
    DOP, /** 
          * Algerian Dinar: Algeria
          */
    DZD, /** 
          * Sucre: Ecuador
          */
    ECS, /** 
          * Unidad de Valor Constante (UVC): Ecuador
          */
    ECV, /** 
          * Kroon: Estonia
          */
    EEK, /** 
          * Egyptian Pound: Egypt
          */
    EGP, /** 
          * Nakfa: Eritrea
          */
    ERN, /** 
          * Spanish Peseta: Andorra, Spain
          */
    ESP, /** 
          * Ethiopian Birr: Ethiopia
          */
    ETB, /** 
          * Euro:
          */
    EUR, /** 
          * Markka: Finland
          */
    FIM, /** 
          * Fiji Dollar: Fiji
          */
    FJD, /** 
          * Pound: Falkland Islands (Malvinas)
          */
    FKP, /** 
          * French Franc: Andorra, France, French Guiana, French Southern Territories, Guadeloupe, Martinique, Monaco, Reunion, St Pierre and Miquelon
          */
    FRF, /** 
          * Pound Sterling: United Kingdom
          */
    GBP, /** 
          * Lari: Georgia
          */
    GEL, /** 
          * Cedi: Ghana
          */
    GHC, /** 
          * Gibraltar Pound: Gibraltar
          */
    GIP, /** 
          * Dalasi: Gambia
          */
    GMD, /** 
          * Guinea Franc: Guinea
          */
    GNF, /** 
          * Drachma: Greece
          */
    GRD, /** 
          * Quetzal: Guatemala
          */
    GTQ, /** 
          * Guinea-Bissau Peso: Guinea-Bissau
          */
    GWP, /** 
          * Guyana Dollar: Guyana
          */
    GYD, /** 
          * Hong Kong Dollar: Hong Kong
          */
    HKD, /** 
          * Lempira: Honduras
          */
    HNL, /** 
          * Kuna: Croatia
          */
    HRK, /** 
          * Gourde: Haiti
          */
    HTG, /** 
          * Forint: Hungary
          */
    HUF, /** 
          * Rupiah: East Timor, Indonesia
          */
    IDR, /** 
          * Irish Pound: Ireland
          */
    IEP, /** 
          * New Israeli Sheqel: Israel
          */
    ILS, /** 
          * Indian Rupee: Bhutan, India
          */
    INR, /** 
          * Iraqi Dinar: Iraq
          */
    IQD, /** 
          * Iranian Rial: Iran (Islamic Republic Of)
          */
    IRR, /** 
          * Iceland Krona: Iceland
          */
    ISK, /** 
          * Italian Lira: Italy, San Marino, Vatican City State (Holy See)
          */
    ITL, /** 
          * Jamaican Dollar: Jamaica
          */
    JMD, /** 
          * Jordanian Dinar: Jordan
          */
    JOD, /** 
          * Yen: Japan
          */
    JPY, /** 
          * Kenyan Shilling: Kenya
          */
    KES, /** 
          * Som: Kyrgyzstan
          */
    KGS, /** 
          * Riel: Cambodia
          */
    KHR, /** 
          * Comoro Franc: Comoros
          */
    KMF, /** 
          * North Korean Won: Korea, Democratic People's Republic Of
          */
    KPW, /** 
          * Won: Korea, Republic Of
          */
    KRW, /** 
          * Kuwaiti Dinar: Kuwait
          */
    KWD, /** 
          * Cayman Islands Dollar: Cayman Islands
          */
    KYD, /** 
          * Tenge: Kazakhstan
          */
    KZT, /** 
          * Kip: Lao People's Democratic Republic
          */
    LAK, /** 
          * Lebanese Pound: Lebanon
          */
    LBP, /** 
          * Sri Lanka Rupee: Sri Lanka
          */
    LKR, /** 
          * Liberian Dollar: Liberia
          */
    LRD, /** 
          * Loti: Lesotho
          */
    LSL, /** 
          * Lithuanian Litas: Lithuania
          */
    LTL, /** 
          * Luxembourg Franc: Luxembourg
          */
    LUF, /** 
          * Latvian Lats: Latvia
          */
    LVL, /** 
          * Libyan Dinar: Libyan Arab Jamahiriya
          */
    LYD, /** 
          * Moroccan Dirham: Morocco, Western Sahara
          */
    MAD, /** 
          * Moldovan Leu: Moldova, Republic Of
          */
    MDL, /** 
          * Malagasy Franc: Madagascar
          */
    MGF, /** 
          * Denar: Macedonia, The Former Yugoslav Republic Of
          */
    MKD, /** 
          * Kyat: Myanmar
          */
    MMK, /** 
          * Tugrik: Mongolia
          */
    MNT, /** 
          * Pataca: Macau
          */
    MOP, /** 
          * Ouguiya: Mauritania
          */
    MRO, /** 
          * Maltese Lira: Malta
          */
    MTL, /** 
          * Mauritius Rupee: Mauritius
          */
    MUR, /** 
          * Rufiyaa: Maldives
          */
    MVR, /** 
          * Kwacha: Malawi
          */
    MWK, /** 
          * Mexican Peso: Mexico
          */
    MXN, /** 
          * Mexican Unidad de Inversion (UDI): Mexico
          */
    MXV, /** 
          * Malaysian Ringgit: Malaysia
          */
    MYR, /** 
          * Metical: Mozambique
          */
    MZM, /** 
          * Namibia Dollar: Namibia
          */
    NAD, /** 
          * Naira: Nigeria
          */
    NGN, /** 
          * Cordoba Oro: Nicaragua
          */
    NIO, /** 
          * Netherlands Guilder: Netherlands
          */
    NLG, /** 
          * Norwegian Krone: Bouvet Island, Norway, Svalbard and Jan Mayen Islands
          */
    NOK, /** 
          * Nepalese Rupee: Nepal
          */
    NPR, /** 
          * New Zealand Dollar: Cook Islands, New Zealand, Niue, Pitcairn, Tokelau
          */
    NZD, /** 
          * Rial Omani: Oman
          */
    OMR, /** 
          * Balboa: Panama
          */
    PAB, /** 
          * Nuevo Sol: Peru
          */
    PEN, /** 
          * Kina: Papua New Guinea
          */
    PGK, /** 
          * Philippine Peso: Philippines
          */
    PHP, /** 
          * Pakistan Rupee: Pakistan
          */
    PKR, /** 
          * Zloty: Poland
          */
    PLN, /** 
          * Portuguese Escudo: Portugal
          */
    PTE, /** 
          * Guarani: Paraguay
          */
    PYG, /** 
          * Qatari Rial: Qatar
          */
    QAR, /** 
          * Leu: Romania
          */
    ROL, /** 
          * Russian Ruble: Russian Federation
          */
    RUB, /** 
          * Russian Ruble: Russian Federation
          */
    RUR, /** 
          * Rwanda Franc: Rwanda
          */
    RWF, /** 
          * Saudi Riyal: Saudi Arabia
          */
    SAR, /** 
          * Solomon Islands Dollar: Solomon Islands
          */
    SBD, /** 
          * Seychelles Rupee: Seychelles
          */
    SCR, /** 
          * Sudanese Dinar: Sudan
          */
    SDD, /** 
          * Swedish Krona: Sweden
          */
    SEK, /** 
          * Singapore Dollar: Singapore
          */
    SGD, /** 
          * St Helena Pound: St Helena
          */
    SHP, /** 
          * Tolar: Slovenia
          */
    SIT, /** 
          * Slovak Koruna: Slovakia
          */
    SKK, /** 
          * Leone: Sierra Leone
          */
    SLL, /** 
          * Somali Shilling: Somalia
          */
    SOS, /** 
          * Surinam Guilder: Suriname
          */
    SRG, /** 
          * Dobra: Sao Tome and Principe
          */
    STD, /** 
          * El Salvador Colon: El Salvador
          */
    SVC, /** 
          * Syrian Pound: Syrian Arab Republic
          */
    SYP, /** 
          * Lilangeni: Swaziland
          */
    SZL, /** 
          * Baht: Thailand
          */
    THB, /** 
          * Tajik Ruble (old): Tajikistan (Old)
          */
    TJR, /** 
          * Somoni: Tajikistan
          */
    TJS, /** 
          * Manat: Turkmenistan
          */
    TMM, /** 
          * Tunisian Dinar: Tunisia
          */
    TND, /** 
          * Pa'anga: Tonga
          */
    TOP, /** 
          * Timor Escudo: East Timor
          */
    TPE, /** 
          * Turkish Lira: Turkey
          */
    TRL, /** 
          * Trinidad and Tobago Dollar: Trinidad and Tobago
          */
    TTD, /** 
          * New Taiwan Dollar: Taiwan, Province Of China
          */
    TWD, /** 
          * Tanzanian Shilling: Tanzania, United Republic Of
          */
    TZS, /** 
          * Hryvnia: Ukraine
          */
    UAH, /** 
          * Uganda Shilling: Uganda
          */
    UGX, /** 
          * US Dollar: American Samoa, British Indian Ocean Territory,, Guam, Haiti, Marshall Islands, Micronesia, Northern Mariana Islands, Palau, Panama, Puerto Rico, Turks and Caicos Islands, United States, United States Minor Outlaying Islands, Virgin Islands (British), Virgin Islands (U.S.)
          */
    USD, /** 
          * (Next day): United States
          */
    USN, /** 
          * (Same day): United States
          */
    USS, /** 
          * Peso Uruguayo: Uruguay
          */
    UYU, /** 
          * Uzbekistan Sum: Uzbekistan
          */
    UZS, /** 
          * Bolivar: Venezuela
          */
    VEB, /** 
          * Bolívar Fuerte: Venezuela
          */
    VEF, /** 
          * Dong: Vietnam
          */
    VND, /** 
          * Vatu: Vanuatu
          */
    VUV, /** 
          * Tala: Samoa
          */
    WST, /** 
          * CFA Franc BEAC: Cameroon, Central African Republic, Chad, Congo, Equatorial Guinea, Gabon
          */
    XAF, /** 
          * Silver: Bond Markets Units
          */
    XAG, /** 
          * Gold Bond Markets Units:
          */
    XAU, /** 
          * European Composite Unit (EURCO): Bond Markets Units
          */
    XBA, /** 
          * European Monetary Unit (E.M.U.-6): Bond Markets Units
          */
    XBB, /** 
          * European Unit of Account 9 (E.U.A.- 9): Bond Markets Units
          */
    XBC, /** 
          * European Unit of Account 17 (E.U.A.- 17): Bond Markets Units
          */
    XBD, /** 
          * East Caribbean Dollar: Anguilla, Antigua and Barbuda, Dominica, Grenada, Montserrat, St Kitts - Nevis, Saint Lucia, Saint Vincent and The Grenadines
          */
    XCD, /** 
          * SDR: International Monetary Fund (Imf)
          */
    XDR, /** 
          * Gold-Franc: Special settlement currencies
          */
    XFO, /** 
          * UIC-Franc: Special settlement currencies
          */
    XFU, /** 
          * CFA Franc BCEAO: Benin, Burkina Faso, Cote D'ivoire, Guinea-Bissau, Mali, Niger, Senegal, Togo
          */
    XOF, /** 
          * Palladium: Bond Markets Units
          */
    XPD, /** 
          * CFP Franc: French Polynesia, New Caledonia, Wallis and Futuna Islands
          */
    XPF, /** 
          * Platinum: Bond Markets Units
          */
    XPT, /** 
          * Codes specifically reserved for testing purposes:
          */
    XTS, /** 
          * The codes assigned for transactions where no currency is involved are::
          */
    XXX, /** 
          * Yemeni Rial: Yemen
          */
    YER, /** 
          * New Dinar: Yugoslavia
          */
    YUM, /** 
          * (financial Rand): Lesotho
          */
    ZAL, /** 
          * Rand: Lesotho, Namibia, South Africa
          */
    ZAR, /** 
          * Kwacha: Zambia
          */
    ZMK, /** 
          * New Zaire: Zaire
          */
    ZRN, /** 
          * Zimbabwe Dollar: Zimbabwe
          */
    ZWD
}
