
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DutyCodeList">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="1"/>
 *     &lt;xs:enumeration value="2"/>
 *     &lt;xs:enumeration value="4"/>
 *     &lt;xs:enumeration value="5"/>
 *     &lt;xs:enumeration value="6"/>
 *     &lt;xs:enumeration value="7"/>
 *     &lt;xs:enumeration value="8"/>
 *     &lt;xs:enumeration value="9"/>
 *     &lt;xs:enumeration value="#"/>
 *     &lt;xs:enumeration value="@"/>
 *     &lt;xs:enumeration value="'"/>
 *     &lt;xs:enumeration value="*"/>
 *     &lt;xs:enumeration value="-"/>
 *     &lt;xs:enumeration value="/"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum DutyCodeList implements Serializable {
    _1("1"), _2("2"), _4("4"), _5("5"), _6("6"), _7("7"), _8("8"), _9("9"), _(
            "#"), _3("@"), _10("'"), _11("*"), _12("-"), _13("/");
    private final String value;

    private DutyCodeList(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static DutyCodeList convert(String value) {
        for (DutyCodeList inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
