
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="E_TicketEligibility">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Eligible"/>
 *     &lt;xs:enumeration value="Not Eligible"/>
 *     &lt;xs:enumeration value="Required"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ETicketEligibility implements Serializable {
    ELIGIBLE("Eligible"), NOT_ELIGIBLE("Not Eligible"), REQUIRED("Required");
    private final String value;

    private ETicketEligibility(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ETicketEligibility convert(String value) {
        for (ETicketEligibility inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
