
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fee.Grouped">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FeeDetails.Misc" name="FeeDetails"/>
 *     &lt;xs:element type="ns:OptionalService" name="OptionalService" minOccurs="0"/>
 *     &lt;xs:element type="ns:Valuation" name="Valuation" minOccurs="0"/>
 *     &lt;xs:element type="ns:Tax.Misc" name="Tax" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:AirportTax" name="AirportTax" minOccurs="0" maxOccurs="32"/>
 *     &lt;xs:element type="ns:DocumentNumber" name="IssuedDocumentNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FeeGrouped implements Serializable
{
    private FeeDetailsMisc feeDetails;
    private OptionalService optionalService;
    private Valuation valuation;
    private List<TaxMisc> taxList = new ArrayList<TaxMisc>();
    private List<AirportTax> airportTaxList = new ArrayList<AirportTax>();
    private DocumentNumber issuedDocumentNumber;

    /** 
     * Get the 'FeeDetails' element value.
     * 
     * @return value
     */
    public FeeDetailsMisc getFeeDetails() {
        return feeDetails;
    }

    /** 
     * Set the 'FeeDetails' element value.
     * 
     * @param feeDetails
     */
    public void setFeeDetails(FeeDetailsMisc feeDetails) {
        this.feeDetails = feeDetails;
    }

    /** 
     * Get the 'OptionalService' element value. Specific information about optional service (OC) as published in ATPCO or Merchandiziing
     * 
     * @return value
     */
    public OptionalService getOptionalService() {
        return optionalService;
    }

    /** 
     * Set the 'OptionalService' element value. Specific information about optional service (OC) as published in ATPCO or Merchandiziing
     * 
     * @param optionalService
     */
    public void setOptionalService(OptionalService optionalService) {
        this.optionalService = optionalService;
    }

    /** 
     * Get the 'Valuation' element value. Additional charges associated to a high value or excess valuation of an item
     * 
     * @return value
     */
    public Valuation getValuation() {
        return valuation;
    }

    /** 
     * Set the 'Valuation' element value. Additional charges associated to a high value or excess valuation of an item
     * 
     * @param valuation
     */
    public void setValuation(Valuation valuation) {
        this.valuation = valuation;
    }

    /** 
     * Get the list of 'Tax' element items.
     * 
     * @return list
     */
    public List<TaxMisc> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items.
     * 
     * @param list
     */
    public void setTaxList(List<TaxMisc> list) {
        taxList = list;
    }

    /** 
     * Get the list of 'AirportTax' element items.
     * 
     * @return list
     */
    public List<AirportTax> getAirportTaxList() {
        return airportTaxList;
    }

    /** 
     * Set the list of 'AirportTax' element items.
     * 
     * @param list
     */
    public void setAirportTaxList(List<AirportTax> list) {
        airportTaxList = list;
    }

    /** 
     * Get the 'IssuedDocumentNumber' element value.
     * 
     * @return value
     */
    public DocumentNumber getIssuedDocumentNumber() {
        return issuedDocumentNumber;
    }

    /** 
     * Set the 'IssuedDocumentNumber' element value.
     * 
     * @param issuedDocumentNumber
     */
    public void setIssuedDocumentNumber(DocumentNumber issuedDocumentNumber) {
        this.issuedDocumentNumber = issuedDocumentNumber;
    }
}
