
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fees.Grouped">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Customer.Misc" name="Customer"/>
 *     &lt;xs:element type="ns:DocumentNumber" name="TicketNumber" minOccurs="0" maxOccurs="6"/>
 *     &lt;xs:element type="ns:Flight.Misc" name="Flight" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="ns:Fee.Grouped" name="Fee" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FeesGrouped implements Serializable
{
    private CustomerMisc customer;
    private List<DocumentNumber> ticketNumberList = new ArrayList<DocumentNumber>();
    private List<FlightMisc> flightList = new ArrayList<FlightMisc>();
    private List<FeeGrouped> feeList = new ArrayList<FeeGrouped>();

    /** 
     * Get the 'Customer' element value.
     * 
     * @return value
     */
    public CustomerMisc getCustomer() {
        return customer;
    }

    /** 
     * Set the 'Customer' element value.
     * 
     * @param customer
     */
    public void setCustomer(CustomerMisc customer) {
        this.customer = customer;
    }

    /** 
     * Get the list of 'TicketNumber' element items. One or more fees are related to one or more ticket numbers. Use TicketNumber if miscellaneous items have PRAS codes that are originally processed thru the following MISC options and required ticket numbers:

    MISC2/1 - SALES ITEMS
    MISC2/2 - SERVICES
    MISC2/3 - UNPAID TAXES
    MISC3 - EXCESS BAGGAGE TICKET
     * 
     * @return list
     */
    public List<DocumentNumber> getTicketNumberList() {
        return ticketNumberList;
    }

    /** 
     * Set the list of 'TicketNumber' element items. One or more fees are related to one or more ticket numbers. Use TicketNumber if miscellaneous items have PRAS codes that are originally processed thru the following MISC options and required ticket numbers:

    MISC2/1 - SALES ITEMS
    MISC2/2 - SERVICES
    MISC2/3 - UNPAID TAXES
    MISC3 - EXCESS BAGGAGE TICKET
     * 
     * @param list
     */
    public void setTicketNumberList(List<DocumentNumber> list) {
        ticketNumberList = list;
    }

    /** 
     * Get the list of 'Flight' element items. One or more fees are related to one or more flight coupons.  Use Flight if miscellaneous items have PRAS codes that are originally processed thru the following MISC options and required flight coupons:

    MISC2/1 - SALES ITEMS
    MISC2/2 - SERVICES
    MISC2/3 - UNPAID TAXES
    MISC3 - EXCESS BAGGAGE TICKET
     * 
     * @return list
     */
    public List<FlightMisc> getFlightList() {
        return flightList;
    }

    /** 
     * Set the list of 'Flight' element items. One or more fees are related to one or more flight coupons.  Use Flight if miscellaneous items have PRAS codes that are originally processed thru the following MISC options and required flight coupons:

    MISC2/1 - SALES ITEMS
    MISC2/2 - SERVICES
    MISC2/3 - UNPAID TAXES
    MISC3 - EXCESS BAGGAGE TICKET
     * 
     * @param list
     */
    public void setFlightList(List<FlightMisc> list) {
        flightList = list;
    }

    /** 
     * Get the list of 'Fee' element items.
     * 
     * @return list
     */
    public List<FeeGrouped> getFeeList() {
        return feeList;
    }

    /** 
     * Set the list of 'Fee' element items.
     * 
     * @param list
     */
    public void setFeeList(List<FeeGrouped> list) {
        feeList = list;
    }
}
