
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight.Misc">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CarrierCode"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService"/>
 *     &lt;xs:element type="xs:string" name="DepartureCity"/>
 *     &lt;xs:element type="xs:string" name="ArrivalCity"/>
 *     &lt;xs:element type="xs:date" name="DepartureDate"/>
 *     &lt;xs:element type="xs:string" name="StopOver" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightMisc implements Serializable
{
    private String carrierCode;
    private String flightNumber;
    private String classOfService;
    private String departureCity;
    private String arrivalCity;
    private Date departureDate;
    private String stopOver;

    /** 
     * Get the 'CarrierCode' element value. The carrier code of the flight associated to the service.  Mapped to:  SR05_42_CXRC
     * 
     * @return value
     */
    public String getCarrierCode() {
        return carrierCode;
    }

    /** 
     * Set the 'CarrierCode' element value. The carrier code of the flight associated to the service.  Mapped to:  SR05_42_CXRC
     * 
     * @param carrierCode
     */
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    /** 
     * Get the 'FlightNumber' element value. The flight number associated to the service.   Mapped to: SR05_42_FLTN
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. The flight number associated to the service.   Mapped to: SR05_42_FLTN
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'ClassOfService' element value. The flight class of service associated to the ancillary service.  Mapped to: SR05_42_CLSV
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. The flight class of service associated to the ancillary service.  Mapped to: SR05_42_CLSV
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'DepartureCity' element value. The origin or depature city code of the flight associated to the service.   Mapped to: SR05_42_DCTY
     * 
     * @return value
     */
    public String getDepartureCity() {
        return departureCity;
    }

    /** 
     * Set the 'DepartureCity' element value. The origin or depature city code of the flight associated to the service.   Mapped to: SR05_42_DCTY
     * 
     * @param departureCity
     */
    public void setDepartureCity(String departureCity) {
        this.departureCity = departureCity;
    }

    /** 
     * Get the 'ArrivalCity' element value. The destination or arrival city of the flight associated to the service.   Mapped to: SR05_42_ACTY
     * 
     * @return value
     */
    public String getArrivalCity() {
        return arrivalCity;
    }

    /** 
     * Set the 'ArrivalCity' element value. The destination or arrival city of the flight associated to the service.   Mapped to: SR05_42_ACTY
     * 
     * @param arrivalCity
     */
    public void setArrivalCity(String arrivalCity) {
        this.arrivalCity = arrivalCity;
    }

    /** 
     * Get the 'DepartureDate' element value. The departure date of the flight associated to the service.  Mapped to: SR05_42_CDTE
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. The departure date of the flight associated to the service.  Mapped to: SR05_42_CDTE
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'StopOver' element value. A code that applies to whether the flight is a stop over or not (X, O).   Mapped to: SR05_42_STOV
     * 
     * @return value
     */
    public String getStopOver() {
        return stopOver;
    }

    /** 
     * Set the 'StopOver' element value. A code that applies to whether the flight is a stop over or not (X, O).   Mapped to: SR05_42_STOV
     * 
     * @param stopOver
     */
    public void setStopOver(String stopOver) {
        this.stopOver = stopOver;
    }
}
