
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightScheduleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Scheduled"/>
 *     &lt;xs:enumeration value="Adhoc"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FlightScheduleType implements Serializable {
    SCHEDULED("Scheduled"), ADHOC("Adhoc");
    private final String value;

    private FlightScheduleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FlightScheduleType convert(String value) {
        for (FlightScheduleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
