
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormOfPaymentChoice.Misc">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:CreditCard.Misc" name="CreditCard"/>
 *     &lt;xs:element type="ns:ExchangeDocument.Misc" name="ExchangeDoc"/>
 *     &lt;xs:element type="xs:string" name="Cash"/>
 *     &lt;xs:element type="ns:Check.Misc" name="Check"/>
 *     &lt;xs:element type="ns:Invoice.Misc" name="Invoice"/>
 *     &lt;xs:element type="ns:GTR.Misc" name="GovTransRequest"/>
 *     &lt;xs:element type="ns:PTA.Misc" name="PrepaidTicketAdvice"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FormOfPaymentChoiceMisc implements Serializable
{
    private int choiceSelect = -1;
    private static final int CREDIT_CARD_CHOICE = 0;
    private static final int EXCHANGE_DOC_CHOICE = 1;
    private static final int CASH_CHOICE = 2;
    private static final int CHECK_CHOICE = 3;
    private static final int INVOICE_CHOICE = 4;
    private static final int GOV_TRANS_REQUEST_CHOICE = 5;
    private static final int PREPAID_TICKET_ADVICE_CHOICE = 6;
    private CreditCardMisc creditCard;
    private ExchangeDocumentMisc exchangeDoc;
    private String cash;
    private CheckMisc check;
    private InvoiceMisc invoice;
    private GTRMisc govTransRequest;
    private PTAMisc prepaidTicketAdvice;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if CreditCard is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCreditCard() {
        return choiceSelect == CREDIT_CARD_CHOICE;
    }

    /** 
     * Get the 'CreditCard' element value. FOP Code=CC
     * 
     * @return value
     */
    public CreditCardMisc getCreditCard() {
        return creditCard;
    }

    /** 
     * Set the 'CreditCard' element value. FOP Code=CC
     * 
     * @param creditCard
     */
    public void setCreditCard(CreditCardMisc creditCard) {
        setChoiceSelect(CREDIT_CARD_CHOICE);
        this.creditCard = creditCard;
    }

    /** 
     * Check if ExchangeDoc is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifExchangeDoc() {
        return choiceSelect == EXCHANGE_DOC_CHOICE;
    }

    /** 
     * Get the 'ExchangeDoc' element value. FOP Code=ET
     * 
     * @return value
     */
    public ExchangeDocumentMisc getExchangeDoc() {
        return exchangeDoc;
    }

    /** 
     * Set the 'ExchangeDoc' element value. FOP Code=ET
     * 
     * @param exchangeDoc
     */
    public void setExchangeDoc(ExchangeDocumentMisc exchangeDoc) {
        setChoiceSelect(EXCHANGE_DOC_CHOICE);
        this.exchangeDoc = exchangeDoc;
    }

    /** 
     * Check if Cash is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCash() {
        return choiceSelect == CASH_CHOICE;
    }

    /** 
     * Get the 'Cash' element value. Presensence of this element indicates a cash transaction; FOP Code=CA
     * 
     * @return value
     */
    public String getCash() {
        return cash;
    }

    /** 
     * Set the 'Cash' element value. Presensence of this element indicates a cash transaction; FOP Code=CA
     * 
     * @param cash
     */
    public void setCash(String cash) {
        setChoiceSelect(CASH_CHOICE);
        this.cash = cash;
    }

    /** 
     * Check if Check is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCheck() {
        return choiceSelect == CHECK_CHOICE;
    }

    /** 
     * Get the 'Check' element value. FOP Code=CK
     * 
     * @return value
     */
    public CheckMisc getCheck() {
        return check;
    }

    /** 
     * Set the 'Check' element value. FOP Code=CK
     * 
     * @param check
     */
    public void setCheck(CheckMisc check) {
        setChoiceSelect(CHECK_CHOICE);
        this.check = check;
    }

    /** 
     * Check if Invoice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifInvoice() {
        return choiceSelect == INVOICE_CHOICE;
    }

    /** 
     * Get the 'Invoice' element value. FOP Code=IN
     * 
     * @return value
     */
    public InvoiceMisc getInvoice() {
        return invoice;
    }

    /** 
     * Set the 'Invoice' element value. FOP Code=IN
     * 
     * @param invoice
     */
    public void setInvoice(InvoiceMisc invoice) {
        setChoiceSelect(INVOICE_CHOICE);
        this.invoice = invoice;
    }

    /** 
     * Check if GovTransRequest is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGovTransRequest() {
        return choiceSelect == GOV_TRANS_REQUEST_CHOICE;
    }

    /** 
     * Get the 'GovTransRequest' element value. FOP Code=GR
     * 
     * @return value
     */
    public GTRMisc getGovTransRequest() {
        return govTransRequest;
    }

    /** 
     * Set the 'GovTransRequest' element value. FOP Code=GR
     * 
     * @param govTransRequest
     */
    public void setGovTransRequest(GTRMisc govTransRequest) {
        setChoiceSelect(GOV_TRANS_REQUEST_CHOICE);
        this.govTransRequest = govTransRequest;
    }

    /** 
     * Check if PrepaidTicketAdvice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPrepaidTicketAdvice() {
        return choiceSelect == PREPAID_TICKET_ADVICE_CHOICE;
    }

    /** 
     * Get the 'PrepaidTicketAdvice' element value. FOP Code = PT
     * 
     * @return value
     */
    public PTAMisc getPrepaidTicketAdvice() {
        return prepaidTicketAdvice;
    }

    /** 
     * Set the 'PrepaidTicketAdvice' element value. FOP Code = PT
     * 
     * @param prepaidTicketAdvice
     */
    public void setPrepaidTicketAdvice(PTAMisc prepaidTicketAdvice) {
        setChoiceSelect(PREPAID_TICKET_ADVICE_CHOICE);
        this.prepaidTicketAdvice = prepaidTicketAdvice;
    }
}
