
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Get.MiscTransInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Location.POS" name="DestCityCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ZipCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="EffectiveDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PnrLocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="NameRefNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GetMiscTransInfo implements Serializable
{
    private LocationPOS destCityCode;
    private String zipCode;
    private Date effectiveDate;
    private String pnrLocator;
    private BigDecimal nameRefNumber;

    /** 
     * Get the 'DestCityCode' element value. Destination city code.  Needed as a parameter to get the correct ancillary or bag fee. Mapped to: SR05_11_TCTY
     * 
     * @return value
     */
    public LocationPOS getDestCityCode() {
        return destCityCode;
    }

    /** 
     * Set the 'DestCityCode' element value. Destination city code.  Needed as a parameter to get the correct ancillary or bag fee. Mapped to: SR05_11_TCTY
     * 
     * @param destCityCode
     */
    public void setDestCityCode(LocationPOS destCityCode) {
        this.destCityCode = destCityCode;
    }

    /** 
     * Get the 'ZipCode' element value. A 5-digit ZIP code that may be needed for the US tax calculation, if applicable (e.g. 76123).  Mapped to: SR05_11_ZIPC
     * 
     * @return value
     */
    public String getZipCode() {
        return zipCode;
    }

    /** 
     * Set the 'ZipCode' element value. A 5-digit ZIP code that may be needed for the US tax calculation, if applicable (e.g. 76123).  Mapped to: SR05_11_ZIPC
     * 
     * @param zipCode
     */
    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    /** 
     * Get the 'EffectiveDate' element value. A 5-digit ZIP code that may be needed for the US tax calculation, if applicable (e.g. 76123).  Mapped to: SR05_11_ZIPC
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. A 5-digit ZIP code that may be needed for the US tax calculation, if applicable (e.g. 76123).  Mapped to: SR05_11_ZIPC
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'PnrLocator' element value. A code associated to the reservations of the customer purchasing an ancillary service.  Mapped to: SR05_11_PNR
     * 
     * @return value
     */
    public String getPnrLocator() {
        return pnrLocator;
    }

    /** 
     * Set the 'PnrLocator' element value. A code associated to the reservations of the customer purchasing an ancillary service.  Mapped to: SR05_11_PNR
     * 
     * @param pnrLocator
     */
    public void setPnrLocator(String pnrLocator) {
        this.pnrLocator = pnrLocator;
    }

    /** 
     * Get the 'NameRefNumber' element value. A name number associated to the traveller or purchaser in the PNR (e.g. 1.1)
     * 
     * @return value
     */
    public BigDecimal getNameRefNumber() {
        return nameRefNumber;
    }

    /** 
     * Set the 'NameRefNumber' element value. A name number associated to the traveller or purchaser in the PNR (e.g. 1.1)
     * 
     * @param nameRefNumber
     */
    public void setNameRefNumber(BigDecimal nameRefNumber) {
        this.nameRefNumber = nameRefNumber;
    }
}
