
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * System identifier used to uniquily identify the specific system.
 "Source" is used to return the application name responsible for fulfilling the particular request transaction.
 "ApplicationInstance" is used to return the application instance responsible for fulfilling the particular request transaction.
 "Cluster" is used to return the application cluster responsible for fulfilling the particular request transaction.
 "HostName" is used to return the particular server name responsible for fulfilling the particular request transaction.

  Example: <Source ApplicationInstance="PROD1" Cluster="PROD TPF SCC" HostName="PSS" xmlns="http://services.sabre.com/STL/v01">TPF</Source> 

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Identifier.System">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="appInstance"/>
 *       &lt;xs:attribute type="xs:string" name="cluster"/>
 *       &lt;xs:attribute type="xs:string" name="host"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IdentifierSystem implements Serializable
{
    private String string;
    private String appInstance;
    private String cluster;
    private String host;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'appInstance' attribute value.
     * 
     * @return value
     */
    public String getAppInstance() {
        return appInstance;
    }

    /** 
     * Set the 'appInstance' attribute value.
     * 
     * @param appInstance
     */
    public void setAppInstance(String appInstance) {
        this.appInstance = appInstance;
    }

    /** 
     * Get the 'cluster' attribute value.
     * 
     * @return value
     */
    public String getCluster() {
        return cluster;
    }

    /** 
     * Set the 'cluster' attribute value.
     * 
     * @param cluster
     */
    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    /** 
     * Get the 'host' attribute value.
     * 
     * @return value
     */
    public String getHost() {
        return host;
    }

    /** 
     * Set the 'host' attribute value.
     * 
     * @param host
     */
    public void setHost(String host) {
        this.host = host;
    }
}
