
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LegStatus">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Active"/>
 *     &lt;xs:enumeration value="Cancelled"/>
 *     &lt;xs:enumeration value="Deleted"/>
 *     &lt;xs:enumeration value="Operated"/>
 *     &lt;xs:enumeration value="Scheduled"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum LegStatus implements Serializable {
    ACTIVE("Active"), CANCELLED("Cancelled"), DELETED("Deleted"), OPERATED(
            "Operated"), SCHEDULED("Scheduled");
    private final String value;

    private LegStatus(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static LegStatus convert(String value) {
        for (LegStatus inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
