
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * A location for an airline or agency agent. Can be used to describe the actual, pseudo or home location.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location.POS">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="country"/>
 *       &lt;xs:attribute type="xs:string" name="province"/>
 *       &lt;xs:attribute type="xs:string" name="number"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LocationPOS implements Serializable
{
    private String string;
    private String country;
    private String province;
    private String number;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'country' attribute value.
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'country' attribute value.
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'province' attribute value.
     * 
     * @return value
     */
    public String getProvince() {
        return province;
    }

    /** 
     * Set the 'province' attribute value.
     * 
     * @param province
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /** 
     * Get the 'number' attribute value. agent station number or agency iata number
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. agent station number or agency iata number
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }
}
