
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PMS_ResStatusType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Reserved"/>
 *     &lt;xs:enumeration value="Requested"/>
 *     &lt;xs:enumeration value="Request denied"/>
 *     &lt;xs:enumeration value="No-show"/>
 *     &lt;xs:enumeration value="Cancelled"/>
 *     &lt;xs:enumeration value="In-house"/>
 *     &lt;xs:enumeration value="Checked out"/>
 *     &lt;xs:enumeration value="Waitlisted"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PMSResStatusType implements Serializable {
    /** 
     * The reservation has been reserved.
     */
    RESERVED("Reserved"), /** 
                           * The reservation has been requested but has not yet been reserved.
                           */
    REQUESTED("Requested"), /** 
                             * The request for the reservation has been denied.
                             */
    REQUESTDENIED("Request denied"), /** 
                                      * This reservation is in "no show" status. Typically this means the person for whom this reservation belonged did not check in and the reservation was moved to "no show" status.
                                      */
    NOSHOW("No-show"), /** 
                        * This reservation has been cancelled.
                        */
    CANCELLED("Cancelled"), /** 
                             * This reservation has been check in, and is in "in-house" status.
                             */
    INHOUSE("In-house"), /** 
                          * The guest has checked out and the reservation has been changed to "Checked out" status
                          */
    CHECKEDOUT("Checked out"), /** 
                                * This reservation is in waitlist status and the reservation has not been confirmed.
                                */
    WAITLISTED("Waitlisted");
    private final String value;

    private PMSResStatusType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PMSResStatusType convert(String value) {
        for (PMSResStatusType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
