
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Example: 
 &lt;PersonName&gt;
 &lt;GivenName&gt;Joshua&lt;/GivenName&gt;
 &lt;MiddelName&gt;Henry&lt;/Middlename&gt;
 &lt;Surname&gt;Smith&lt;/Surname&gt;
 &lt;/PersonName&gt;
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName.Simple">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="Surname"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PersonNameSimple implements Serializable
{
    private List<String> givenNameList = new ArrayList<String>();
    private List<String> middleNameList = new ArrayList<String>();
    private String surname;

    /** 
     * Get the list of 'GivenName' element items.
     * 
     * @return list
     */
    public List<String> getGivenNameList() {
        return givenNameList;
    }

    /** 
     * Set the list of 'GivenName' element items.
     * 
     * @param list
     */
    public void setGivenNameList(List<String> list) {
        givenNameList = list;
    }

    /** 
     * Get the list of 'MiddleName' element items.
     * 
     * @return list
     */
    public List<String> getMiddleNameList() {
        return middleNameList;
    }

    /** 
     * Set the list of 'MiddleName' element items.
     * 
     * @param list
     */
    public void setMiddleNameList(List<String> list) {
        middleNameList = list;
    }

    /** 
     * Get the 'Surname' element value.
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value.
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }
}
