
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingSourceType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Published"/>
 *     &lt;xs:enumeration value="Private"/>
 *     &lt;xs:enumeration value="Both"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PricingSourceType implements Serializable {
    /** 
     * Published fare.
     */
    PUBLISHED("Published"), /** 
                             * Private fare.
                             */
    PRIVATE("Private"), /** 
                         * Fare is both public and private.
                         */
    BOTH("Both");
    private final String value;

    private PricingSourceType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PricingSourceType convert(String value) {
        for (PricingSourceType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
