
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Per stay"/>
 *     &lt;xs:enumeration value="Per person"/>
 *     &lt;xs:enumeration value="Per night"/>
 *     &lt;xs:enumeration value="Per person per night"/>
 *     &lt;xs:enumeration value="Per use"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PricingType implements Serializable {
    PERSTAY("Per stay"), PERPERSON("Per person"), PERNIGHT("Per night"), PERPERSONPERNIGHT(
            "Per person per night"), PERUSE("Per use");
    private final String value;

    private PricingType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PricingType convert(String value) {
        for (PricingType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
