
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Sabre Standard Payload Header. Information in the header is intended to separate transport and processing information from actual message data. Header information may be replicated in the messaging system header (SOAP or JMS header). This data is inteded for use with content-based routing and other tasks asscociated with integration.  NOTE: messaging and transport systems may and should add content to the header whereas they should never change the actual message subject contents.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" abstract="true" name="STL_HeaderBase">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TrackingID" name="ConversationID" minOccurs="0"/>
 *     &lt;xs:element type="ns:TrackingID" name="OrchestrationID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Operation" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Service" minOccurs="0"/>
 *     &lt;xs:element type="ns:MessagingRecords" name="Messaging" minOccurs="0"/>
 *     &lt;xs:element type="ns:Parameters" name="Parameters" minOccurs="0" maxOccurs="100"/>
 *     &lt;xs:element type="ns:SecurityTokenCG" name="Security" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DiagnosticData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="messageID"/>
 *   &lt;xs:attribute type="xs:string" name="version"/>
 *   &lt;xs:attribute type="xs:dateTime" name="timeStamp"/>
 *   &lt;xs:attribute type="xs:string" name="customerID"/>
 *   &lt;xs:attribute type="ns:DiagnosticLevels" name="diagnosticLevel"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public abstract class STLHeaderBase implements Serializable
{
    private TrackingID conversationID;
    private TrackingID orchestrationID;
    private String operation;
    private String service;
    private MessagingRecords messaging;
    private List<Parameters> parameterList = new ArrayList<Parameters>();
    private SecurityTokenCG security;
    private String diagnosticData;
    private String messageID;
    private String version;
    private Date timeStamp;
    private String customerID;
    private DiagnosticLevels diagnosticLevel;

    /** 
     * Get the 'ConversationID' element value. The ConversationId element is a string identifying the set of related messages that make up a conversation between two Parties. The Party initiating a conversation determines the value of the ConversationId element that shall be reflected in all messages pertaining to that conversation. It remains constant for all messages within a conversation.
     * 
     * @return value
     */
    public TrackingID getConversationID() {
        return conversationID;
    }

    /** 
     * Set the 'ConversationID' element value. The ConversationId element is a string identifying the set of related messages that make up a conversation between two Parties. The Party initiating a conversation determines the value of the ConversationId element that shall be reflected in all messages pertaining to that conversation. It remains constant for all messages within a conversation.
     * 
     * @param conversationID
     */
    public void setConversationID(TrackingID conversationID) {
        this.conversationID = conversationID;
    }

    /** 
     * Get the 'OrchestrationID' element value. The orchestration ID may be used to track a set of service invocations and the sequence in which they are invoked. To track an orchestration, the orchestrator assigns a unique value to the identifier and sets the sequence number to 0.  Service providers are expected to increment the OrchestrationID@seq value if it exists.
     * 
     * @return value
     */
    public TrackingID getOrchestrationID() {
        return orchestrationID;
    }

    /** 
     * Set the 'OrchestrationID' element value. The orchestration ID may be used to track a set of service invocations and the sequence in which they are invoked. To track an orchestration, the orchestrator assigns a unique value to the identifier and sets the sequence number to 0.  Service providers are expected to increment the OrchestrationID@seq value if it exists.
     * 
     * @param orchestrationID
     */
    public void setOrchestrationID(TrackingID orchestrationID) {
        this.orchestrationID = orchestrationID;
    }

    /** 
     * Get the 'Operation' element value. Operation is the actiion verb applied to the Service.
     * 
     * @return value
     */
    public String getOperation() {
        return operation;
    }

    /** 
     * Set the 'Operation' element value. Operation is the actiion verb applied to the Service.
     * 
     * @param operation
     */
    public void setOperation(String operation) {
        this.operation = operation;
    }

    /** 
     * Get the 'Service' element value. The name of the service being requested. Typically the message subject noun.  Service frameworks may use the abstract service name to lookup the actual service provider instance to invoke.
     * 
     * @return value
     */
    public String getService() {
        return service;
    }

    /** 
     * Set the 'Service' element value. The name of the service being requested. Typically the message subject noun.  Service frameworks may use the abstract service name to lookup the actual service provider instance to invoke.
     * 
     * @param service
     */
    public void setService(String service) {
        this.service = service;
    }

    /** 
     * Get the 'Messaging' element value. Messaging section provides an area for each system interacting with the message to record a brief message about thier interactions. Service proxies and utility services such as transformation and validation should use this area to record when they processed the message and the resulting status.
     * 
     * @return value
     */
    public MessagingRecords getMessaging() {
        return messaging;
    }

    /** 
     * Set the 'Messaging' element value. Messaging section provides an area for each system interacting with the message to record a brief message about thier interactions. Service proxies and utility services such as transformation and validation should use this area to record when they processed the message and the resulting status.
     * 
     * @param messaging
     */
    public void setMessaging(MessagingRecords messaging) {
        this.messaging = messaging;
    }

    /** 
     * Get the list of 'Parameters' element items. Generalized name-value pairs. These parameters are intended for integration specific use only during development and testing. These parameters must not be relied upon for production operation.
     * 
     * @return list
     */
    public List<Parameters> getParameterList() {
        return parameterList;
    }

    /** 
     * Set the list of 'Parameters' element items. Generalized name-value pairs. These parameters are intended for integration specific use only during development and testing. These parameters must not be relied upon for production operation.
     * 
     * @param list
     */
    public void setParameterList(List<Parameters> list) {
        parameterList = list;
    }

    /** 
     * Get the 'Security' element value.
     * 
     * @return value
     */
    public SecurityTokenCG getSecurity() {
        return security;
    }

    /** 
     * Set the 'Security' element value.
     * 
     * @param security
     */
    public void setSecurity(SecurityTokenCG security) {
        this.security = security;
    }

    /** 
     * Get the 'DiagnosticData' element value.
     * 
     * @return value
     */
    public String getDiagnosticData() {
        return diagnosticData;
    }

    /** 
     * Set the 'DiagnosticData' element value.
     * 
     * @param diagnosticData
     */
    public void setDiagnosticData(String diagnosticData) {
        this.diagnosticData = diagnosticData;
    }

    /** 
     * Get the 'messageID' attribute value. The MessageId element is a globally unique identifier for each message [see RFC2822]. It is an unique message identifier that refers to a particular version of a particular message.  The uniqueness of the message identifier should be guaranteed by the host that generates it.  This message identifier is intended to be machine readable and not necessarily meaningful to humans.  A message identifier pertains to exactly one instantiation of a particular message; subsequent revisions to the message each receive new message identifiers.
     * 
     * @return value
     */
    public String getMessageID() {
        return messageID;
    }

    /** 
     * Set the 'messageID' attribute value. The MessageId element is a globally unique identifier for each message [see RFC2822]. It is an unique message identifier that refers to a particular version of a particular message.  The uniqueness of the message identifier should be guaranteed by the host that generates it.  This message identifier is intended to be machine readable and not necessarily meaningful to humans.  A message identifier pertains to exactly one instantiation of a particular message; subsequent revisions to the message each receive new message identifiers.
     * 
     * @param messageID
     */
    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    /** 
     * Get the 'version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'timeStamp' attribute value. Date and time when the result record was created.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value. Date and time when the result record was created.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'customerID' attribute value. Identification value assigned to the service customer or consumer. The identifier will often be a pseudo city code.
     * 
     * @return value
     */
    public String getCustomerID() {
        return customerID;
    }

    /** 
     * Set the 'customerID' attribute value. Identification value assigned to the service customer or consumer. The identifier will often be a pseudo city code.
     * 
     * @param customerID
     */
    public void setCustomerID(String customerID) {
        this.customerID = customerID;
    }

    /** 
     * Get the 'diagnosticLevel' attribute value.
     * 
     * @return value
     */
    public DiagnosticLevels getDiagnosticLevel() {
        return diagnosticLevel;
    }

    /** 
     * Set the 'diagnosticLevel' attribute value.
     * 
     * @param diagnosticLevel
     */
    public void setDiagnosticLevel(DiagnosticLevels diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel;
    }
}
