
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="STL_HeaderCG">
 *   &lt;xs:choice>
 *     &lt;xs:element ref="ns:STL_Header.RQ"/>
 *     &lt;xs:element ref="ns:STL_Header.RS"/>
 *     &lt;xs:element ref="ns:STL_Header.Notif"/>
 *     &lt;xs:element ref="ns:STL_Header.Ack"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class STLHeaderCG implements Serializable
{
    private int choiceSelect = -1;
    private static final int STL_HEADER_RQ_CHOICE = 0;
    private static final int STL_HEADER_RS_CHOICE = 1;
    private static final int STL_HEADER_NOTIF_CHOICE = 2;
    private static final int STL_HEADER_ACK_CHOICE = 3;
    private STLHeaderRQ STLHeaderRQ;
    private STLHeaderRS STLHeaderRS;
    private STLHeaderNotif STLHeaderNotif;
    private STLHeaderAck STLHeaderAck;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if STLHeaderRQ is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSTLHeaderRQ() {
        return choiceSelect == STL_HEADER_RQ_CHOICE;
    }

    /** 
     * Get the 'STL_Header.RQ' element value.
     * 
     * @return value
     */
    public STLHeaderRQ getSTLHeaderRQ() {
        return STLHeaderRQ;
    }

    /** 
     * Set the 'STL_Header.RQ' element value.
     * 
     * @param STLHeaderRQ
     */
    public void setSTLHeaderRQ(STLHeaderRQ STLHeaderRQ) {
        setChoiceSelect(STL_HEADER_RQ_CHOICE);
        this.STLHeaderRQ = STLHeaderRQ;
    }

    /** 
     * Check if STLHeaderRS is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSTLHeaderRS() {
        return choiceSelect == STL_HEADER_RS_CHOICE;
    }

    /** 
     * Get the 'STL_Header.RS' element value.
     * 
     * @return value
     */
    public STLHeaderRS getSTLHeaderRS() {
        return STLHeaderRS;
    }

    /** 
     * Set the 'STL_Header.RS' element value.
     * 
     * @param STLHeaderRS
     */
    public void setSTLHeaderRS(STLHeaderRS STLHeaderRS) {
        setChoiceSelect(STL_HEADER_RS_CHOICE);
        this.STLHeaderRS = STLHeaderRS;
    }

    /** 
     * Check if STLHeaderNotif is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSTLHeaderNotif() {
        return choiceSelect == STL_HEADER_NOTIF_CHOICE;
    }

    /** 
     * Get the 'STL_Header.Notif' element value.
     * 
     * @return value
     */
    public STLHeaderNotif getSTLHeaderNotif() {
        return STLHeaderNotif;
    }

    /** 
     * Set the 'STL_Header.Notif' element value.
     * 
     * @param STLHeaderNotif
     */
    public void setSTLHeaderNotif(STLHeaderNotif STLHeaderNotif) {
        setChoiceSelect(STL_HEADER_NOTIF_CHOICE);
        this.STLHeaderNotif = STLHeaderNotif;
    }

    /** 
     * Check if STLHeaderAck is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSTLHeaderAck() {
        return choiceSelect == STL_HEADER_ACK_CHOICE;
    }

    /** 
     * Get the 'STL_Header.Ack' element value.
     * 
     * @return value
     */
    public STLHeaderAck getSTLHeaderAck() {
        return STLHeaderAck;
    }

    /** 
     * Set the 'STL_Header.Ack' element value.
     * 
     * @param STLHeaderAck
     */
    public void setSTLHeaderAck(STLHeaderAck STLHeaderAck) {
        setChoiceSelect(STL_HEADER_ACK_CHOICE);
        this.STLHeaderAck = STLHeaderAck;
    }
}
