
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShareIndicator">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Yes"/>
 *     &lt;xs:enumeration value="No"/>
 *     &lt;xs:enumeration value="Inherit"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ShareIndicator implements Serializable {
    YES("Yes"), NO("No"), INHERIT("Inherit");
    private final String value;

    private ShareIndicator(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ShareIndicator convert(String value) {
        for (ShareIndicator inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
