
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Street">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="StreetNmbrSuffix"/>
 *       &lt;xs:attribute type="xs:string" name="StreetDirection"/>
 *       &lt;xs:attribute type="xs:string" name="RuralRouteNmbr"/>
 *       &lt;xs:attribute type="xs:string" name="PO_Box"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Street implements Serializable
{
    private String string;
    private String streetNmbrSuffix;
    private String streetDirection;
    private String ruralRouteNmbr;
    private String POBox;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'StreetNmbrSuffix' attribute value. Usually a letter right after the street number (A in 66-A, B in 123-B etc).
     * 
     * @return value
     */
    public String getStreetNmbrSuffix() {
        return streetNmbrSuffix;
    }

    /** 
     * Set the 'StreetNmbrSuffix' attribute value. Usually a letter right after the street number (A in 66-A, B in 123-B etc).
     * 
     * @param streetNmbrSuffix
     */
    public void setStreetNmbrSuffix(String streetNmbrSuffix) {
        this.streetNmbrSuffix = streetNmbrSuffix;
    }

    /** 
     * Get the 'StreetDirection' attribute value. Street direction of an address (e.g., N, E, S, NW, SW).
     * 
     * @return value
     */
    public String getStreetDirection() {
        return streetDirection;
    }

    /** 
     * Set the 'StreetDirection' attribute value. Street direction of an address (e.g., N, E, S, NW, SW).
     * 
     * @param streetDirection
     */
    public void setStreetDirection(String streetDirection) {
        this.streetDirection = streetDirection;
    }

    /** 
     * Get the 'RuralRouteNmbr' attribute value. Numerical equivalent of a rural township as defined within a given area (e.g., 12, 99).
     * 
     * @return value
     */
    public String getRuralRouteNmbr() {
        return ruralRouteNmbr;
    }

    /** 
     * Set the 'RuralRouteNmbr' attribute value. Numerical equivalent of a rural township as defined within a given area (e.g., 12, 99).
     * 
     * @param ruralRouteNmbr
     */
    public void setRuralRouteNmbr(String ruralRouteNmbr) {
        this.ruralRouteNmbr = ruralRouteNmbr;
    }

    /** 
     * Get the 'PO_Box' attribute value. Defines a Post Office Box number.
     * 
     * @return value
     */
    public String getPOBox() {
        return POBox;
    }

    /** 
     * Set the 'PO_Box' attribute value. Defines a Post Office Box number.
     * 
     * @param POBox
     */
    public void setPOBox(String POBox) {
        this.POBox = POBox;
    }
}
