
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="eTicket"/>
 *     &lt;xs:enumeration value="Paper"/>
 *     &lt;xs:enumeration value="MCO"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TicketType implements Serializable {
    /** 
     * An electronic ticket
     */
    E_TICKET("eTicket"), /** 
                          * A paper ticket
                          */
    PAPER("Paper"), /** 
                     * A miscellaneous charge order
                     */
    MCO("MCO");
    private final String value;

    private TicketType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TicketType convert(String value) {
        for (TicketType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
