
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeUnit">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Year"/>
 *     &lt;xs:enumeration value="Month"/>
 *     &lt;xs:enumeration value="Week"/>
 *     &lt;xs:enumeration value="Day"/>
 *     &lt;xs:enumeration value="Hour"/>
 *     &lt;xs:enumeration value="Second"/>
 *     &lt;xs:enumeration value="FullDuration"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TimeUnit implements Serializable {
    YEAR("Year"), MONTH("Month"), WEEK("Week"), DAY("Day"), HOUR("Hour"), SECOND(
            "Second"), FULL_DURATION("FullDuration");
    private final String value;

    private TimeUnit(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TimeUnit convert(String value) {
        for (TimeUnit inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
