
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Valuation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="TotalDeclaredValue"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService"/>
 *     &lt;xs:element type="ns:WeightCode" name="WeightCode"/>
 *     &lt;xs:element type="xs:integer" name="TotalWeight"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Valuation implements Serializable
{
    private Amount totalDeclaredValue;
    private String classOfService;
    private WeightCode weightCode;
    private BigInteger totalWeight;

    /** 
     * Get the 'TotalDeclaredValue' element value. The value of an item for purposes of purchasing additional insurance of that item (e.g. high-value paint).  Mapped to: SR05_C1_DAMT
     * 
     * @return value
     */
    public Amount getTotalDeclaredValue() {
        return totalDeclaredValue;
    }

    /** 
     * Set the 'TotalDeclaredValue' element value. The value of an item for purposes of purchasing additional insurance of that item (e.g. high-value paint).  Mapped to: SR05_C1_DAMT
     * 
     * @param totalDeclaredValue
     */
    public void setTotalDeclaredValue(Amount totalDeclaredValue) {
        this.totalDeclaredValue = totalDeclaredValue;
    }

    /** 
     * Get the 'ClassOfService' element value. For international travel, the class of service needed for calculating the cost of the insurance.  Mapped to: SR05_C1_CSER
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. For international travel, the class of service needed for calculating the cost of the insurance.  Mapped to: SR05_C1_CSER
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'WeightCode' element value. The weight (kilos, pounds) of the item needed for calculation.  Mapped to:  SR05_C1_WCDE
     * 
     * @return value
     */
    public WeightCode getWeightCode() {
        return weightCode;
    }

    /** 
     * Set the 'WeightCode' element value. The weight (kilos, pounds) of the item needed for calculation.  Mapped to:  SR05_C1_WCDE
     * 
     * @param weightCode
     */
    public void setWeightCode(WeightCode weightCode) {
        this.weightCode = weightCode;
    }

    /** 
     * Get the 'TotalWeight' element value. Total weight of the item.  Mapped to: SR05_C1_TWGT
     * 
     * @return value
     */
    public BigInteger getTotalWeight() {
        return totalWeight;
    }

    /** 
     * Set the 'TotalWeight' element value. Total weight of the item.  Mapped to: SR05_C1_TWGT
     * 
     * @param totalWeight
     */
    public void setTotalWeight(BigInteger totalWeight) {
        this.totalWeight = totalWeight;
    }
}
